/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Molecule;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;

@PropertyName(value="Substance")
@ClassIcon(value="resources/substance.gif")
public class Substance
extends Molecule {
    private String casRegistryNumber;
    private String formula;

    public Substance(DataCollection origin, String name) {
        super(origin, name);
    }

    @Override
    public String getType() {
        return "molecule-substance";
    }

    @PropertyName(value="Formula")
    @PropertyDescription(value="Substance chemical formula.")
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.formula;
        this.formula = formula;
        this.firePropertyChange("formula", oldValue, formula);
    }

    @PropertyName(value="CAS")
    @PropertyDescription(value="CAS Registry Number. <br>It provides unique substance numeric identifier and <br>can contain up to 9 digits, divided by hyphens into 3 parts. <br>For example, 58-08-2 is the CAS Registry Number for caffeine.")
    public String getCasRegistryNumber() {
        return this.casRegistryNumber;
    }

    public void setCasRegistryNumber(String casRegistryNumber) {
        String oldValue = this.casRegistryNumber;
        this.casRegistryNumber = casRegistryNumber;
        this.firePropertyChange("casRegistryNumber", oldValue, casRegistryNumber);
    }
}

