/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.CDKRenderer;
import biouml.standard.type.Referrer;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import ru.biosoft.access.ImageElement;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.graphics.access.ViewUtils;
import ru.biosoft.util.ImageUtils;

@ClassIcon(value="resources/structure.gif")
@PropertyName(value="Structure")
@PropertyDescription(value="2D or 3D molecule structure.")
public class Structure
extends Referrer
implements ImageElement {
    private static final long serialVersionUID = -5883830389078341253L;
    protected String[] moleculeReferences;
    protected String format;
    protected String data;

    public Structure(DataCollection origin, String name) {
        super(origin, name);
    }

    @Override
    public String getType() {
        return "structure";
    }

    @PropertyName(value="Molecules")
    @PropertyDescription(value="Molecule or molecules which structure is described.")
    public String[] getMoleculeReferences() {
        return this.moleculeReferences;
    }

    public void setMoleculeReferences(String[] moleculeReferences) {
        String[] oldValue = this.moleculeReferences;
        this.moleculeReferences = moleculeReferences;
        this.firePropertyChange("moleculeReferences", oldValue, moleculeReferences);
    }

    @PropertyName(value="Format")
    @PropertyDescription(value="Format of molecule structure data.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        String oldValue = this.format;
        this.format = format;
        this.firePropertyChange("format", oldValue, format);
    }

    @PropertyName(value="Data")
    @PropertyDescription(value="Molecule structure data.")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        String oldValue = this.data;
        this.data = data;
        this.firePropertyChange("data", oldValue, data);
    }

    public BufferedImage getImage(Dimension dimension) {
        Dimension d = dimension == null ? this.getImageSize() : ImageUtils.correctImageSize((Dimension)dimension);
        try {
            return CDKRenderer.createStructureImage(this, d);
        }
        catch (Exception e) {
            return ViewUtils.paintException((Throwable)e);
        }
    }

    public Dimension getImageSize() {
        try {
            IMolecule molecule = CDKRenderer.loadMolecule(this);
            double avgBond = GeometryTools.getBondLengthAverage((IAtomContainer)molecule);
            if (Double.isNaN(avgBond)) {
                return new Dimension(500, 500);
            }
            double scale = 40.0 / avgBond;
            double[] bounds = CDKRenderer.getBounds((IAtomContainer)molecule);
            bounds[0] = bounds[0] * scale;
            bounds[1] = bounds[1] * scale;
            return ImageUtils.correctImageSize((Dimension)new Dimension((int)bounds[0], (int)bounds[1]));
        }
        catch (Exception e) {
            return new Dimension(500, 500);
        }
    }
}

