/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.BaseSupport;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang.StringEscapeUtils;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.plugins.jsconsistent.JavaScriptConsistent;

@ClassIcon(value="resources/species.gif")
public class Species
extends BaseSupport
implements JavaScriptConsistent {
    private static final long serialVersionUID = 1L;
    public static final DataElementPath SPECIES_PATH = DataElementPath.create((String)"databases/Utils/Species");
    public static final String ANY_SPECIES = "Any species";
    private String commonName;
    private String abbreviation;
    private String description;
    private static Map<String, Species> speciesCache = new ConcurrentHashMap<String, Species>();

    public Species(DataCollection<?> parent, String name) {
        super(parent, name);
    }

    public String getLatinName() {
        return this.getName();
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        String oldValue = commonName;
        this.commonName = commonName;
        this.firePropertyChange("commonName", oldValue, commonName);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        String oldValue = abbreviation;
        this.abbreviation = abbreviation;
        this.firePropertyChange("abbreviation", oldValue, abbreviation);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = description;
        this.description = description;
        this.firePropertyChange("description", oldValue, description);
    }

    public String toString() {
        return this.getCommonName() + " (" + this.getName() + ")";
    }

    public static Species getDefaultSpecies(DataCollection<?> collection) {
        Species species;
        String speciesStr;
        if (collection != null && (speciesStr = collection.getInfo().getProperty(DataCollectionUtils.SPECIES_PROPERTY)) != null && (species = Species.getSpecies(speciesStr)) != null) {
            return species;
        }
        return Species.getSpecies("Homo sapiens");
    }

    public static StreamEx<Species> allSpecies() {
        return StreamEx.of((Stream)SPECIES_PATH.getDataCollection(Species.class).stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Species getSpecies(String latinName) {
        Species result = speciesCache.get(latinName);
        if (result != null) {
            return result;
        }
        Species de = (Species)SPECIES_PATH.getChildPath(new String[]{latinName}).optDataElement(Species.class);
        if (de == null) {
            return null;
        }
        Map<String, Species> map = speciesCache;
        synchronized (map) {
            speciesCache.put(latinName, de);
        }
        return de;
    }

    public static Species createInstance(String data) {
        Species speciesElement = (Species)DataElementPath.create((String)data).optDataElement(Species.class);
        if (speciesElement != null) {
            return speciesElement;
        }
        for (Species species : SPECIES_PATH.getDataCollection(Species.class)) {
            if (!species.getLatinName().equals(data) && !species.toString().equals(data)) continue;
            return species;
        }
        return null;
    }

    public static String formatSpeciesNames() {
        if (!SPECIES_PATH.exists()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List allSpecies = Species.allSpecies().map(s -> s.getCommonName().toLowerCase(Locale.ENGLISH)).toList();
        for (int i = 0; i < allSpecies.size(); ++i) {
            sb.append((String)allSpecies.get(i));
            if (i < allSpecies.size() - 2) {
                sb.append(", ");
                continue;
            }
            if (i != allSpecies.size() - 2) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    private Object writeReplace() {
        return new SpeciesProxy(this.getLatinName());
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public String toJaveScriptString() {
        return "'" + StringEscapeUtils.escapeJava((String)this.getName()) + "'";
    }

    private static class SpeciesProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String latinName;

        public SpeciesProxy(String latinName) {
            this.latinName = latinName;
        }

        private Object readResolve() {
            return Species.getSpecies(this.latinName);
        }
    }
}

