/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.GlobalViewOptions;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.FormulaDelegate;
import biouml.model.dynamics.VariableRole;
import biouml.standard.type.GenericEntity;
import biouml.standard.type.Reaction;
import biouml.standard.type.Relation;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.support.SerializableAsText;

@PropertyName(value="Species reference")
@PropertyDescription(value="Reference to species involved into the reaction, its role and stoichiometry.")
public class SpecieReference
extends GenericEntity
implements Relation,
FormulaDelegate,
SerializableAsText {
    public static final String REACTANT = "reactant";
    public static final String PRODUCT = "product";
    public static final String MODIFIER = "modifier";
    public static final String OTHER = "other";
    public static final String[] specieRoles = new String[]{"reactant", "product", "modifier"};
    public static final String ACTION_CATALYSIS = "catalysis";
    public static final String ACTION_INHIBITION = "inhibition";
    public static final String ACTION_MODULATION = "modulation";
    public static final String ACTION_STIMULATION = "stimulation";
    public static final String ACTION_NECCESSARY_STIMULATION = "necessary stimulation";
    public static final String ACTION_CATALYST = "catalyst";
    public static final String ACTION_INHIBITOR = "inhibitor";
    public static final String ACTION_SWITCH_ON = "switch on";
    public static final String ACTION_SWITCH_OFF = "switch off";
    public static final String[] modifierActions = new String[]{"catalysis", "inhibition", "modulation", "stimulation", "necessary stimulation"};
    protected static final Logger log = Logger.getLogger(SpecieReference.class.getName());
    protected String specie;
    private String role;
    protected String stoichiometry = "1";
    boolean isInitialized = true;
    protected String modifierAction;
    private String participation = "direct";

    public SpecieReference(DataCollection<?> origin, String name) {
        this(origin, name, REACTANT);
    }

    public SpecieReference(DataCollection<?> origin, String name, String role) {
        super(origin, name);
        this.role = role;
        if (MODIFIER.equals(role)) {
            this.modifierAction = ACTION_CATALYSIS;
        }
    }

    public SpecieReference(DataCollection<?> origin, String reactionName, String speciesName, String role) {
        this(origin, SpecieReference.generateSpecieReferenceName(reactionName, speciesName, role), role);
    }

    public SpecieReference(String descr) {
        super(null, "no name yet");
        StringTokenizer tokens = new StringTokenizer(descr, "\t");
        try {
            this.name = tokens.nextToken();
            int index = this.name.indexOf(": ");
            this.title = index > 0 ? this.name.substring(index + 2) : this.name;
            index = this.name.indexOf(" as ");
            if (index >= 0) {
                this.role = this.name.substring(index + 4);
            }
            if (this.role != null && this.role.equals(MODIFIER)) {
                this.modifierAction = tokens.nextToken();
            }
            this.specie = tokens.nextToken();
            this.stoichiometry = tokens.nextToken();
            this.participation = tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                this.comment = tokens.nextToken();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not parse SpecieReference \"" + descr + "\". Error :" + t, t);
        }
    }

    public String getAsText() {
        StringBuffer buffer = new StringBuffer(this.name);
        if (this.role.equals(MODIFIER)) {
            buffer.append("\t" + this.modifierAction);
        }
        buffer.append("\t" + this.specie);
        buffer.append("\t" + this.stoichiometry);
        buffer.append("\t" + this.participation);
        if (this.comment != null) {
            buffer.append("\t" + this.comment);
        }
        return buffer.toString();
    }

    @Override
    public SpecieReference clone(DataCollection<?> origin, String name) {
        SpecieReference role = new SpecieReference(origin, name);
        role.title = this.getTitle();
        role.comment = this.getComment();
        role.specie = this.getSpecie();
        role.role = this.getRole();
        role.stoichiometry = this.getStoichiometry();
        role.modifierAction = this.getModifierAction();
        role.participation = this.getParticipation();
        return role;
    }

    @Override
    public String getType() {
        return "relation-chemical";
    }

    public String getSpecieName() {
        if (this.specie != null) {
            int offset = this.specie.lastIndexOf(47);
            return offset > 0 ? this.specie.substring(offset + 1) : this.specie;
        }
        return null;
    }

    public Optional<String> optSpecieName() {
        if (this.specie != null) {
            int offset = this.specie.lastIndexOf(47);
            if (offset > 0) {
                return Optional.of(this.specie.substring(offset + 1));
            }
            return Optional.of(this.specie);
        }
        return Optional.empty();
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Name of species involved into the reaction.")
    public String getSpecie() {
        return this.specie;
    }

    public void setSpecie(String specie) {
        String oldValue = this.specie;
        this.specie = specie;
        this.firePropertyChange("specie", oldValue, specie);
    }

    public VariableRole getSpecieVariableRole(Diagram diagram) {
        try {
            DiagramElement de = diagram.findDiagramElement(this.getSpecieName());
            return (VariableRole)de.getRole();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Name of specie involved into the reaction.")
    public String getSpecieVariable() {
        Diagram diagram;
        VariableRole role;
        if (this.getOrigin() instanceof Compartment && (role = this.getSpecieVariableRole(diagram = Diagram.getDiagram((Compartment)this.getOrigin()))) != null) {
            return role.getName();
        }
        return "$" + this.getSpecieName();
    }

    public String getSpecieVariable(Diagram diagram) {
        if (diagram != null && diagram.getRole() instanceof EModel) {
            try {
                DiagramElement de = diagram.findDiagramElement(this.getSpecieName());
                if (de != null && de.getRole() instanceof VariableRole) {
                    String result = de.getRole(VariableRole.class).getName();
                    return diagram.getRole(EModel.class).getQualifiedName(result, de, GlobalViewOptions.getVarNameMode());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "$" + this.getSpecieName();
    }

    @PropertyName(value="Role")
    @PropertyDescription(value="Role of specie in the reaction.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        String oldValue = this.role;
        this.role = role;
        if (!this.isInitialized()) {
            String newName = SpecieReference.generateSpecieReferenceName(this.getOrigin().getName(), this.optSpecieName().orElse(this.name), role);
            if (MODIFIER.equals(role)) {
                this.setModifierAction(ACTION_CATALYSIS);
            }
            this.setTitle(newName);
        }
        this.firePropertyChange("role", oldValue, role);
    }

    public boolean isReactantOrProduct() {
        return !MODIFIER.equals(this.role);
    }

    public boolean isReactant() {
        return REACTANT.equals(this.role);
    }

    public boolean isProduct() {
        return PRODUCT.equals(this.role);
    }

    public void setInitialized(boolean initialized) {
        this.isInitialized = initialized;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @PropertyName(value="Stoichiometry")
    @PropertyDescription(value="Stoichiometry of involved molecule")
    public String getStoichiometry() {
        return this.stoichiometry;
    }

    public void setStoichiometry(String stoichiometry) {
        String oldValue = this.stoichiometry;
        this.stoichiometry = stoichiometry;
        this.firePropertyChange("stoichiometry", oldValue, stoichiometry);
    }

    @PropertyName(value="Modifier action")
    @PropertyDescription(value="Specifies the modifier action.<br>This value is needed only if role is MODIFIER, othervise it should be empty.")
    public String getModifierAction() {
        return this.modifierAction;
    }

    public void setModifierAction(String modifierAction) {
        String oldValue = this.modifierAction;
        this.modifierAction = modifierAction;
        this.firePropertyChange("modifierAction", oldValue, modifierAction);
    }

    @Override
    @PropertyName(value="Participation")
    @PropertyDescription(value="Specifies whether the element directly involved into relation.")
    public String getParticipation() {
        return this.participation;
    }

    public void setParticipation(String participation) {
        String oldValue = this.participation;
        this.participation = participation;
        this.firePropertyChange("participation", oldValue, participation);
    }

    @Override
    public String getFormula() {
        if (this.role.equals(MODIFIER)) {
            return "0";
        }
        try {
            Reaction reaction = (Reaction)this.getOrigin();
            if (reaction == null) {
                return null;
            }
            String rate = reaction.getFormula();
            if (rate == null || rate.trim().length() == 0) {
                return null;
            }
        }
        catch (Exception reaction) {
            // empty catch block
        }
        StringBuffer formula = new StringBuffer();
        if (this.role.equals(REACTANT)) {
            formula.append("-");
        }
        formula.append("$$rate_" + this.getOrigin().getName());
        if (this.stoichiometry != null && this.stoichiometry.length() > 0 && !this.stoichiometry.equals("1")) {
            formula.append("*(" + this.stoichiometry + ")");
        }
        return formula.toString();
    }

    @Override
    public void setFormula(String formula) {
    }

    public static String generateSpecieReferenceName(String reactionName, String specieName, String role) {
        return reactionName + "__" + specieName + "_as_" + role;
    }
}

