/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Referrer;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.core.DataCollection;

@PropertyName(value="Species")
@PropertyDescription(value="The terms <i>species</i> refers to entities that take part in reactions.")
public class Specie
extends Referrer {
    protected int charge;
    private String[] availableTypes;
    private static final String[] specieTypes = new String[]{"molecule-substance", "molecule-gene", "molecule-RNA", "molecule-protein"};

    public Specie(DataCollection parent, String name) {
        this(parent, name, "molecule-substance");
    }

    public Specie(DataCollection parent, String name, String type) {
        super(parent, name, type);
        this.availableTypes = specieTypes;
    }

    public Specie(DataCollection parent, String name, String type, String[] types) {
        super(parent, name, type);
        this.availableTypes = types;
    }

    @Override
    @PropertyName(value="Type")
    @PropertyDescription(value="Type of species (chemical substance, enzyme, gene, etc.)")
    public String getType() {
        return super.getType();
    }

    public void setType(String type) {
        String oldValue = this.type;
        this.type = type;
        this.firePropertyChange("type", oldValue, type);
    }

    @PropertyName(value="Charge")
    @PropertyDescription(value="Indicates the charge of the species in terms of electrons.")
    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        int oldValue = this.charge;
        this.charge = charge;
        this.firePropertyChange("charge", oldValue, charge);
    }

    public String[] getAvailableTypes() {
        return this.availableTypes;
    }

    public void setAvailableTypes(String[] types) {
        this.availableTypes = types;
        if (types.length > 0) {
            this.type = types[0];
        }
    }
}

