/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.Module;
import biouml.standard.diagram.DatabaseReferencesPropertyEditor;
import biouml.standard.type.GenericEntityBeanInfo;
import biouml.standard.type.Publication;
import biouml.standard.type.Referrer;
import biouml.standard.type.access.TitleIndex;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.access.support.DataCollectionMultyChoiceDialog;
import ru.biosoft.access.support.DataCollectionMultyChoicePropertyEditor;

public class ReferrerBeanInfo<T extends Referrer>
extends GenericEntityBeanInfo<T> {
    protected static final Logger log = Logger.getLogger(ReferrerBeanInfo.class.getName());

    protected ReferrerBeanInfo(Class<? extends T> r) {
        super(r);
    }

    protected ReferrerBeanInfo(Class beanClass, String key) {
        super(beanClass, key);
    }

    @Override
    public void initProperties() throws Exception {
        super.initProperties();
        this.property("description").htmlDisplayName("DE").add(4);
        this.property("databaseReferences").editor(DatabaseReferencesPropertyEditor.class).htmlDisplayName("DR").add();
        this.property("literatureReferences").htmlDisplayName("RF").editor(LiteratureReferencesEditor.class).add();
    }

    public static class LiteratureReferencesEditor
    extends DataCollectionMultyChoicePropertyEditor {
        public static final String REFERENCE = "reference";
        private DataCollection dc;
        private TitleIndex index;

        public LiteratureReferencesEditor() {
            this.title = "LiteratureReferencesEditor";
        }

        public DataCollection getDataCollection() throws Exception {
            DataElement de = (DataElement)this.getBean();
            Module module = Module.optModule(de);
            if (module != null) {
                this.dc = module.getCategory(Publication.class);
                if (this.dc == null) {
                    log.info("Module \"" + module.getName() + "\" doesn't contain collection for literature references.");
                } else if (this.dc.getInfo().getQuerySystem() != null && this.dc.getInfo().getQuerySystem().getIndex(REFERENCE) != null) {
                    this.index = (TitleIndex)this.dc.getInfo().getQuerySystem().getIndex(REFERENCE);
                }
            }
            return this.dc;
        }

        protected void initEditButtonListener() {
            this.editButton.addActionListener(e -> {
                try {
                    DataCollectionMultyChoiceDialog dialog;
                    DataCollection dc = this.getDataCollection();
                    if (dc == null) {
                        dc = new VectorDataCollection("tmp_literatures", Publication.class, null);
                    }
                    if ((dialog = new DataCollectionMultyChoiceDialog(this.parent, this.title, dc, REFERENCE, this.getReferences(), true)).doModal()) {
                        this.setReferences(dialog.getSelectedValues());
                    }
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, t.getMessage(), t);
                }
            });
        }

        public String[] getReferences() {
            if (this.index != null) {
                return (String[])StreamEx.of((Object)this.getValue()).map(this.index::get).toArray(String[]::new);
            }
            return (String[])((String[])this.getValue()).clone();
        }

        public void setReferences(String[] references) {
            if (this.index != null) {
                this.setValue(StreamEx.of((Object[])references).map(this.index::getIdByTitle).toArray(String[]::new));
            }
            this.setValue(references);
        }
    }
}

