/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.DatabaseReference;
import biouml.standard.type.GenericEntity;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public abstract class Referrer
extends GenericEntity {
    private static final long serialVersionUID = -3116188284353933758L;
    private String description;
    private DatabaseReference[] databaseReferences = null;
    private String[] literatureReferences;

    protected Referrer(DataCollection origin, String name) {
        super(origin, name);
    }

    protected Referrer(DataCollection origin, String name, String type) {
        super(origin, name, type);
    }

    @PropertyName(value="Description")
    @PropertyDescription(value="The object textual description (plain text or HTML).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.firePropertyChange("description", oldValue, description);
    }

    @PropertyName(value="Database references")
    @PropertyDescription(value="Database cross-reference.<br>Cross-references to other databases that contain information related to the entry. For instance, line pointing to the relevant SWISS-PROT entry will be in the DR field for the protein. <p>General format is:<pre>database_identifier; primary_identifier; secondary_identifier.</pre>Example:<pre>SWISS-PROT; P03593; V90K_AMV.</pre>")
    public DatabaseReference[] getDatabaseReferences() {
        return this.databaseReferences;
    }

    public void setDatabaseReferences(DatabaseReference[] databaseReferences) {
        DatabaseReference[] oldValue = this.databaseReferences;
        this.databaseReferences = databaseReferences;
        if (databaseReferences != null) {
            for (DatabaseReference dr : databaseReferences) {
                dr.setParent((Option)this);
            }
        }
        this.firePropertyChange("databaseReferences", oldValue, databaseReferences);
    }

    public void addDatabaseReferences(DatabaseReference ... newReferences) {
        if (newReferences == null) {
            return;
        }
        DatabaseReference[] curRefs = this.getDatabaseReferences();
        this.setDatabaseReferences(curRefs == null ? newReferences : (DatabaseReference[])((StreamEx)StreamEx.of((Object[])curRefs).append((Object[])newReferences).distinct()).toArray(DatabaseReference[]::new));
    }

    @PropertyName(value="Bibliography")
    @PropertyDescription(value="The field contains references to the original papers. The reference provides access to the paper within the database from which the data has been extracted. <p> The format is:<pre>Reference identifier</pre>Example:<pre>Gilmour K.C. and Reich N.C., 1995</pre>")
    public String[] getLiteratureReferences() {
        return this.literatureReferences;
    }

    public void setLiteratureReferences(String[] literatureReferences) {
        String[] oldValue = this.literatureReferences;
        this.literatureReferences = literatureReferences;
        this.firePropertyChange("literatureReferences", oldValue, literatureReferences);
    }

    public DatabaseReference[] getDatabaseReferences(String relationshipType) {
        if (this.databaseReferences == null) {
            return new DatabaseReference[0];
        }
        return (DatabaseReference[])((StreamEx)StreamEx.of((Object[])this.databaseReferences).filter(ref -> ref.getRelationshipType().equals(relationshipType))).toArray(DatabaseReference[]::new);
    }

    @Override
    public Referrer clone(DataCollection<?> newOrigin, String newName) {
        Referrer clone = (Referrer)super.clone((DataCollection)newOrigin, newName);
        if (this.literatureReferences != null) {
            clone.literatureReferences = (String[])this.literatureReferences.clone();
        }
        if (this.databaseReferences != null) {
            clone.databaseReferences = (DatabaseReference[])StreamEx.of((Object[])this.databaseReferences).map(DatabaseReference::new).toArray(DatabaseReference[]::new);
        }
        return clone;
    }
}

