/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.dynamics.FormulaDelegate;
import biouml.standard.type.Base;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Referrer;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionInfo;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementPutException;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.LoggedException;
import ru.biosoft.util.TextUtil;

@ClassIcon(value="resources/reaction.gif")
@PropertyName(value="Reaction")
public class Reaction
extends Referrer
implements DataCollection<SpecieReference>,
FormulaDelegate {
    public static final DecimalFormat NAME_FORMAT = new DecimalFormat("R000000");
    protected VectorDataCollection<SpecieReference> collection;
    protected KineticLaw kineticLaw;
    protected boolean reversible;
    protected boolean fast;
    private DataElementPath completeName = null;

    public Reaction(DataCollection<?> origin, String name) {
        super(origin, name, "reaction");
        this.init(name);
    }

    protected void init(String name) {
        String dcName = TextUtil.nullToEmpty((String)name);
        this.collection = new VectorDataCollection(dcName);
        this.kineticLaw = new KineticLaw(this);
    }

    public String getSpecieTitle(Integer index, Object obj) {
        SpecieReference specie = (SpecieReference)obj;
        return specie.getTitle();
    }

    @PropertyName(value="Species references")
    @PropertyDescription(value="References to species involved into the reaction, its role and stoichiometry.")
    @Nonnull
    public SpecieReference[] getSpecieReferences() {
        return (SpecieReference[])this.collection.toArray((DataElement[])new SpecieReference[this.collection.getSize()]);
    }

    public void setSpecieReferences(SpecieReference[] species) {
        SpecieReference[] oldValue = this.getSpecieReferences();
        Set oldNames = this.collection.names().collect(Collectors.toSet());
        for (SpecieReference sr : species) {
            this.collection.put((DataElement)sr);
            oldNames.remove(sr.getName());
        }
        for (String oldName : oldNames) {
            try {
                this.collection.remove(oldName);
            }
            catch (Exception e) {
                throw ExceptionRegistry.translateException((Throwable)e);
            }
        }
        this.firePropertyChange("specieReferences", oldValue, this.getSpecieReferences());
    }

    @PropertyName(value="Kinetic law")
    @PropertyDescription(value="Kinetic law describes the reaction kinetics.")
    public KineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public void setKineticLaw(KineticLaw kineticLaw) {
        KineticLaw oldValue = this.kineticLaw;
        this.kineticLaw = kineticLaw;
        kineticLaw.setParent((Option)this);
        this.firePropertyChange("kineticLaw", (Object)oldValue, (Object)kineticLaw);
    }

    @PropertyName(value="Reversible")
    @PropertyDescription(value="Indicates whether the reaction is reversible.")
    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        boolean oldValue = this.reversible;
        this.reversible = reversible;
        this.firePropertyChange("reversible", oldValue, reversible);
    }

    @PropertyName(value="Fast")
    @PropertyDescription(value="Indicates whether the reaction is fast.")
    public boolean isFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        boolean oldValue = this.fast;
        this.fast = fast;
        this.firePropertyChange("fast", oldValue, fast);
    }

    @Override
    public String getFormula() {
        return this.kineticLaw.getFormula();
    }

    @Override
    public void setFormula(String formula) {
        this.kineticLaw.setFormula(formula);
    }

    public DataCollectionInfo getInfo() {
        return this.collection.getInfo();
    }

    public int getSize() {
        return this.collection.getSize();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Nonnull
    public Class<Base> getDataElementType() {
        return Base.class;
    }

    public boolean isMutable() {
        return this.collection.isMutable();
    }

    public boolean contains(String name) {
        return this.collection.contains(name);
    }

    public boolean contains(DataElement de) {
        return this.contains(de.getName());
    }

    @Nonnull
    public Iterator<SpecieReference> iterator() {
        return this.collection.iterator();
    }

    @Nonnull
    public List<String> getNameList() {
        return this.collection.getNameList();
    }

    public SpecieReference get(String name) throws Exception {
        return (SpecieReference)this.collection.get(name);
    }

    public DataElementDescriptor getDescriptor(String name) {
        return this.collection.getDescriptor(name);
    }

    public SpecieReference put(SpecieReference obj) throws DataElementPutException {
        SpecieReference oldRef = (SpecieReference)this.collection.get(obj.getName());
        this.setSpecieReferences((SpecieReference[])Stream.concat(Stream.of(obj), this.collection.stream().filter(sr -> !sr.getName().equals(obj.getName()))).toArray(SpecieReference[]::new));
        return oldRef;
    }

    public void remove(String name) throws Exception {
        this.setSpecieReferences((SpecieReference[])this.collection.stream().filter(sr -> !sr.getName().equals(name)).toArray(SpecieReference[]::new));
    }

    public void addDataCollectionListener(DataCollectionListener l) {
        this.collection.addDataCollectionListener(l);
    }

    public void removeDataCollectionListener(DataCollectionListener l) {
        this.collection.removeDataCollectionListener(l);
    }

    @Nonnull
    public DataElementPath getCompletePath() {
        if (this.completeName == null) {
            DataCollection origin = this.getOrigin();
            this.completeName = (origin == null ? DataElementPath.EMPTY_PATH : origin.getCompletePath()).getChildPath(new String[]{this.getName()});
        }
        return this.completeName;
    }

    public void close() throws Exception {
    }

    public void init() {
    }

    public void release(String dataElementName) {
    }

    public DataElement getFromCache(String dataElementName) {
        return null;
    }

    public boolean isPropagationEnabled() {
        return this.collection.isPropagationEnabled();
    }

    public void setPropagationEnabled(boolean propagationEnabled) {
        this.collection.setPropagationEnabled(propagationEnabled);
    }

    public void propagateElementWillChange(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.collection.propagateElementWillChange(source, primaryEvent);
    }

    public void propagateElementChanged(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.collection.propagateElementChanged(source, primaryEvent);
    }

    public boolean isAcceptable(Class<? extends DataElement> clazz) {
        return SpecieReference.class.isAssignableFrom(clazz);
    }

    public boolean isValid() {
        return true;
    }

    public void reinitialize() throws LoggedException {
    }

    @Override
    public Reaction clone(DataCollection<?> newOrigin, String newName) {
        Reaction clone = (Reaction)super.clone((DataCollection)newOrigin, newName);
        clone.listenerList = null;
        clone.collection = new VectorDataCollection(this.collection.getName());
        this.collection.stream().map(sr -> new SpecieReference((DataCollection<?>)clone.collection, sr.getName())).forEach(arg_0 -> clone.collection.put(arg_0));
        clone.kineticLaw = new KineticLaw(clone, this.kineticLaw);
        return clone;
    }

    public StreamEx<SpecieReference> stream() {
        if (this.isEmpty()) {
            return StreamEx.empty();
        }
        return StreamEx.of((Stream)this.names()).map(name -> {
            try {
                return this.get((String)name);
            }
            catch (Exception e) {
                throw ExceptionRegistry.translateException((Throwable)e);
            }
        });
    }
}

