/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.Entry;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.access.support.EntryParser;

public class Publication
extends MutableDataElementSupport {
    protected static final Logger log = Logger.getLogger(Publication.class.getName());
    protected static final String medlineQuery = "http://www.ncbi.nlm.nih.gov/entrez/utils/pmfetch.fcgi?db=PubMed&report=MEDLINE&mode=text&id=";
    protected long creationTime = System.currentTimeMillis();
    private String reference;
    private String pubMedId;
    private String authors;
    private String affiliation;
    private String title;
    private String journalTitle;
    private String volume;
    private String issue;
    private String pageFrom;
    private String pageTo;
    private String year;
    private String month;
    private String publicationAbstract;
    private String fullTextURL;
    private String language;
    private String publicationType;
    private String status;
    private String keywords;
    public int importance;
    private String comment;
    private String db;
    private String dbVersion;
    private String idName;
    private String idVersion;
    private String simpleSource;

    public static Publication importFromMedline(String pubMedId, DataCollection parent, boolean checkParent) {
        return null;
    }

    protected void initFromMedline(String pubMedId) {
        try {
            String prefix;
            String pages;
            URL url = new URL(medlineQuery + pubMedId);
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(20000);
            conn.connect();
            Object content = conn.getContent();
            if (content == null) {
                log.log(Level.SEVERE, "Can not get entry with uid '" + pubMedId + "' from PubMed. Content is null.");
                return;
            }
            StringBuffer result = new StringBuffer();
            try (InputStream is = (InputStream)content;){
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = is.read(bytes)) > 0) {
                    result.append(new String(bytes, 0, len));
                }
            }
            String entryStr = result.toString();
            Entry entry = new Entry(null, this.name, entryStr);
            this.pubMedId = EntryParser.parseStringValue((Entry)entry, (String)"PMID-");
            this.affiliation = EntryParser.parseStringValue((Entry)entry, (String)"AD  -");
            this.title = EntryParser.parseStringValue((Entry)entry, (String)"TI  -");
            this.journalTitle = EntryParser.parseStringValue((Entry)entry, (String)"TA  -");
            this.volume = EntryParser.parseStringValue((Entry)entry, (String)"VI  -");
            this.issue = EntryParser.parseStringValue((Entry)entry, (String)"IP  -");
            this.publicationAbstract = EntryParser.parseStringValue((Entry)entry, (String)"AB  -");
            this.language = EntryParser.parseStringValue((Entry)entry, (String)"LA  -");
            this.publicationType = EntryParser.parseStringValue((Entry)entry, (String)"PT  -");
            String dp = EntryParser.parseStringValue((Entry)entry, (String)"DP  -");
            this.year = dp.substring(0, 4);
            this.month = dp.length() > 5 ? dp.substring(5) : "";
            this.pageFrom = pages = EntryParser.parseStringValue((Entry)entry, (String)"PG  -");
            this.pageTo = pages;
            if (pages != null) {
                int delim = pages.indexOf(45);
                if (delim == -1) {
                    delim = pages.indexOf(44);
                }
                if (delim != -1) {
                    this.pageFrom = pages.substring(0, delim).trim();
                    this.pageTo = pages.substring(delim + 1).trim();
                }
            }
            if (entryStr.indexOf(prefix = "\nFAU") < 1) {
                prefix = "\nAU";
            }
            int from = 0;
            result = new StringBuffer();
            while ((from = entryStr.indexOf(prefix, from)) > 0) {
                int to = entryStr.indexOf(10, from + 2);
                if (to < 0) {
                    to = entryStr.length() - 1;
                }
                result.append(entryStr.substring(from + 7, to));
                result.append(";\n");
                from = to;
            }
            this.authors = result.toString();
            this.reference = this.generateReference();
            this.firePropertyChange("*", null, null);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not get entry with uid '" + this.name + "' from PubMed.", t);
        }
    }

    public Publication(DataCollection parent, String name) {
        super(parent, name);
    }

    protected String generateReference() {
        StringTokenizer tokens = new StringTokenizer(this.getAuthors(), ",\n");
        int num = tokens.countTokens();
        String id = num == 0 ? this.getTitle() : (num == 1 ? this.getAuthorLastName(tokens.nextToken()) + ", " + this.year : (num == 2 ? this.getAuthorLastName(tokens.nextToken()) + " and " + this.getAuthorLastName(tokens.nextToken()) + ", " + this.year : this.getAuthorLastName(tokens.nextToken()) + " et al., " + this.year));
        if (this.getOrigin() != null && this.getOrigin().contains(id)) {
            char letter = 'a';
            while (this.getOrigin().contains(id + letter)) {
                letter = (char)(letter + '\u0001');
            }
            id = id + letter;
        }
        return id;
    }

    protected String getAuthorLastName(String author) {
        int offset = author.lastIndexOf(32);
        if (offset > 0) {
            author = author.substring(0, offset);
        }
        return author;
    }

    public String getReference() {
        if (this.reference == null) {
            this.reference = this.generateReference();
        }
        return this.reference;
    }

    public void setReference(String reference) {
        String oldValue = reference;
        this.reference = reference;
        this.firePropertyChange("reference", oldValue, reference);
    }

    protected void updateReference() {
        String ref;
        if (System.currentTimeMillis() - this.creationTime > 500L && (ref = this.generateReference()) != null && !ref.equals(this.reference)) {
            String oldValue = this.reference;
            this.reference = ref;
            this.firePropertyChange("reference", oldValue, this.reference);
        }
    }

    public String getPubMedId() {
        return this.pubMedId;
    }

    public void setPubMedId(String pubMedId) {
        String oldValue = pubMedId;
        this.pubMedId = pubMedId;
        this.firePropertyChange("pubMedId", oldValue, pubMedId);
    }

    public String getAuthors() {
        if (this.authors == null) {
            return "";
        }
        return this.authors;
    }

    public void setAuthors(String authors) {
        String oldValue = authors;
        this.authors = authors;
        this.firePropertyChange("authors", oldValue, authors);
        this.updateReference();
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        String oldValue = affiliation;
        this.affiliation = affiliation;
        this.firePropertyChange("affiliation", oldValue, affiliation);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    public String getSource() {
        if (this.journalTitle == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(this.journalTitle);
        buf.append(". ");
        buf.append(this.getYear());
        if (this.getMonth() != null && !this.getMonth().equals("")) {
            buf.append(" " + this.getMonth());
        }
        buf.append(';');
        if (this.getVolume() != null && !this.getVolume().equals("")) {
            buf.append(this.getVolume());
        }
        if (this.getIssue() != null && !this.getIssue().equals("")) {
            buf.append("(" + this.getIssue() + ")");
        }
        if (this.getPageFrom() != null && !this.getPageFrom().equals("")) {
            buf.append(":" + this.getPageFrom());
        }
        if (this.getPageTo() != null && !this.getPageTo().equals("")) {
            buf.append("-" + this.pageTo);
        }
        return buf.toString();
    }

    public String getJournalTitle() {
        return this.journalTitle;
    }

    public void setJournalTitle(String journalTitle) {
        String oldValue = journalTitle;
        this.journalTitle = journalTitle;
        this.firePropertyChange("journalTitle", oldValue, journalTitle);
        this.firePropertyChange("source", null, null);
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        String oldValue = volume;
        this.volume = volume;
        this.firePropertyChange("volume", oldValue, volume);
        this.firePropertyChange("source", null, null);
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        String oldValue = issue;
        this.issue = issue;
        this.firePropertyChange("issue", oldValue, issue);
        this.firePropertyChange("source", null, null);
    }

    public String getPageFrom() {
        return this.pageFrom;
    }

    public void setPageFrom(String pagination) {
        String oldValue = this.pageFrom;
        this.pageFrom = pagination;
        this.firePropertyChange("pageFrom", oldValue, pagination);
        this.firePropertyChange("source", null, null);
    }

    public String getPageTo() {
        return this.pageTo;
    }

    public void setPageTo(String pagination) {
        String oldValue = this.pageTo;
        this.pageTo = pagination;
        this.firePropertyChange("pageTo", oldValue, pagination);
        this.firePropertyChange("source", null, null);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = year;
        this.year = year;
        this.firePropertyChange("year", oldValue, year);
        this.firePropertyChange("source", null, null);
        this.updateReference();
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        String oldValue = month;
        this.month = month;
        this.firePropertyChange("month", oldValue, month);
        this.firePropertyChange("source", null, null);
    }

    public String getPublicationAbstract() {
        return this.publicationAbstract;
    }

    public void setPublicationAbstract(String publicationAbstract) {
        String oldValue = publicationAbstract;
        this.publicationAbstract = publicationAbstract;
        this.firePropertyChange("publicationAbstract", oldValue, publicationAbstract);
    }

    public String getFullTextURL() {
        return this.fullTextURL;
    }

    public void setFullTextURL(String fullTextURL) {
        String oldValue = fullTextURL;
        this.fullTextURL = fullTextURL;
        this.firePropertyChange("fullTextURL", oldValue, fullTextURL);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        String oldValue = language;
        this.language = language;
        this.firePropertyChange("language", oldValue, language);
    }

    public String getPublicationType() {
        return this.publicationType;
    }

    public void setPublicationType(String publicationType) {
        String oldValue = publicationType;
        this.publicationType = publicationType;
        this.firePropertyChange("publicationType", oldValue, publicationType);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        String oldValue = status;
        this.status = status;
        this.firePropertyChange("status", oldValue, status);
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        String oldValue = keywords;
        this.keywords = keywords;
        this.firePropertyChange("keywords", oldValue, keywords);
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        int oldValue = importance;
        this.importance = importance;
        this.firePropertyChange("importance", oldValue, importance);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public String getIdVersion() {
        return this.idVersion;
    }

    public void setIdVersion(String idVersion) {
        this.idVersion = idVersion;
    }

    public String getSimpleSource() {
        return this.simpleSource;
    }

    public void setSimpleSource(String simpleSource) {
        this.simpleSource = simpleSource;
    }
}

