/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Biopolymer;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;

@ClassIcon(value="resources/protein.gif")
@PropertyName(value="Protein")
public class Protein
extends Biopolymer {
    public static final String[] proteinFunctionalStates = new String[]{"active", "inactive", "unknown"};
    public static final String[] proteinStructures = new String[]{"monomer", "homodimer", "heterodimer", "multimer", "unknown"};
    public static final String[] proteinModifications = new String[]{"none", "phosphorylated", "fatty_acylation", "prenylation", "cholesterolation", "ubiquitination", "sumolation", "glycation", "gpi_anchor", "unknown"};
    private String gene;
    private String functionalState;
    private String structure;
    private String modification;

    public Protein(DataCollection origin, String name) {
        super((DataCollection<?>)origin, name);
    }

    @Override
    public String getType() {
        return "molecule-protein";
    }

    @PropertyName(value="Gene ID")
    @PropertyDescription(value="Identifier of  gene (in the given database) encoded this protein or RNA.")
    public String getGene() {
        return this.gene;
    }

    public void setGene(String gene) {
        String oldValue = this.gene;
        this.gene = gene;
        this.firePropertyChange("gene", oldValue, gene);
    }

    @PropertyName(value="Functional state")
    @PropertyDescription(value="Functional state of the protein.")
    public String getFunctionalState() {
        return this.functionalState;
    }

    public void setFunctionalState(String functionalState) {
        String oldValue = this.functionalState;
        this.functionalState = functionalState;
        this.firePropertyChange("functionalState", oldValue, functionalState);
    }

    @PropertyName(value="Structure")
    @PropertyDescription(value="Top level structure descripton of the protein.Possible values are:<ul><li>unknown</li><li>monomer</li><li>homodimer</li><li>heterodimer</li><li>multimer - this value specifies proteins consisted of three or more components.</li></ul>")
    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        String oldValue = this.structure;
        this.structure = structure;
        this.firePropertyChange("structure", oldValue, structure);
    }

    @PropertyName(value="Modification")
    @PropertyDescription(value="Modefication of the protein.")
    public String getModification() {
        return this.modification;
    }

    public void setModification(String modification) {
        String oldValue = this.modification;
        this.modification = modification;
        this.firePropertyChange("modification", oldValue, modification);
    }
}

