/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.Module;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Publication;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.access.core.RepositoryException;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.util.LazyValue;

public class LinkResolver {
    public static final DataElementPath MIRIAM_RESOURCE = DataElementPath.create((String)"databases/Utils/MIRIAM");
    private static Logger log = Logger.getLogger(LinkResolver.class.getName());
    private DataCollection<DatabaseInfo> miriamCollection;
    private final LazyValue<Map<String, String>> uriList = new LazyValue<Map<String, String>>("MIRIAM uriList"){

        protected Map<String, String> doGet() throws Exception {
            if (LinkResolver.this.miriamCollection != null) {
                return StreamEx.of((Stream)LinkResolver.this.miriamCollection.stream()).mapToEntry(info -> info.getAttributes().getValue("uris"), MutableDataElementSupport::getName).selectKeys(String[].class).flatMapKeys(Arrays::stream).toMap();
            }
            return Collections.emptyMap();
        }
    };

    public LinkResolver() {
        try {
            this.miriamCollection = MIRIAM_RESOURCE.getDataCollection(DatabaseInfo.class);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getQueryById(DataElement de, DatabaseReference ref) {
        String result = "";
        String databaseName = ref.getDatabaseName();
        try {
            DatabaseInfo info = null;
            DataCollection<DatabaseInfo> databaseInfos = this.getDatabaseInfoCollection(de);
            if (databaseInfos != null) {
                info = (DatabaseInfo)databaseInfos.get(databaseName);
                if (info == null) {
                    info = databaseInfos.stream().filter(dbInfo -> dbInfo.getTitle().equals(databaseName)).findFirst().orElse(null);
                }
                if (this.miriamCollection != null && info != null && info.getDatabaseReferences() != null) {
                    for (DatabaseReference reference : info.getDatabaseReferences()) {
                        if (!this.miriamCollection.contains(reference.getId())) continue;
                        info = (DatabaseInfo)this.miriamCollection.get(reference.getId());
                        break;
                    }
                }
            }
            if (info == null && this.miriamCollection != null && (info = (DatabaseInfo)this.miriamCollection.get(databaseName)) == null) {
                info = this.getDatabaseInfoByUri(databaseName);
            }
            if (info != null) {
                result = info.getQueryById();
                String id = ref.getId();
                result = result.replace("$id$", id);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "LinkResolver: can not get query by id, " + e);
        }
        return result;
    }

    public String getDatabaseTitle(DataElement de, DatabaseReference ref) {
        String databaseName = ref.getDatabaseName();
        BaseSupport info = null;
        try {
            DataCollection<DatabaseInfo> databaseInfos = this.getDatabaseInfoCollection(de);
            if (databaseInfos != null && databaseInfos.contains(databaseName)) {
                info = (DatabaseInfo)databaseInfos.get(databaseName);
            } else if (this.miriamCollection != null && (info = (DatabaseInfo)this.miriamCollection.get(databaseName)) == null) {
                info = this.getDatabaseInfoByUri(databaseName);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't process database reference: " + ExceptionRegistry.log((Throwable)e));
        }
        if (info != null) {
            return info.getTitle();
        }
        return databaseName;
    }

    public String getQueryById(DataElement de, String publicationID) {
        String result = "";
        try {
            if (this.miriamCollection != null) {
                DatabaseInfo dbInfo;
                DataCollection literature = this.getLiteratureCollection(de);
                String pmid = null;
                pmid = literature != null ? ((Publication)literature.get(publicationID)).getPubMedId() : publicationID;
                if (pmid != null && !pmid.equals("") && !pmid.equals("0") && (dbInfo = (DatabaseInfo)this.miriamCollection.get("MIR:00000015")) != null) {
                    result = dbInfo.getQueryById();
                    result = result.replace("$id$", pmid);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not process publication " + publicationID);
        }
        return result;
    }

    public String getReference(DataElement de, String publicationID) {
        String result = publicationID;
        try {
            DataCollection literature = this.getLiteratureCollection(de);
            result = literature != null ? ((Publication)literature.get(publicationID)).getReference() : publicationID;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not process publication " + publicationID);
        }
        return result;
    }

    protected DataCollection<DatabaseInfo> getDatabaseInfoCollection(DataElement de) throws Exception {
        DataElementPath modulePath = Module.optModulePath(de);
        if (modulePath == null) {
            return null;
        }
        return modulePath.getChildPath(new String[]{"Dictionaries", "database info"}).optDataCollection(DatabaseInfo.class);
    }

    protected DataCollection getLiteratureCollection(DataElement de) throws Exception {
        DataCollection literature = null;
        Module module = Module.optModule(de);
        if (module != null && module.get("Data") != null) {
            DataCollection data = (DataCollection)module.get("Data");
            literature = (DataCollection)data.get("literature");
        }
        return literature;
    }

    protected DatabaseInfo getDatabaseInfoByUri(String uri) throws Exception {
        if (this.miriamCollection != null && ((Map)this.uriList.get()).containsKey(uri)) {
            return (DatabaseInfo)this.miriamCollection.get((String)((Map)this.uriList.get()).get(uri));
        }
        return null;
    }

    public DataElement getDataElement(String completeName) {
        return CollectionFactory.getDataElement((String)completeName);
    }

    public Module getModule(DataElement de) {
        return Module.optModule(de);
    }
}

