/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Reaction;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;

@PropertyName(value="Kinetic law")
@PropertyDescription(value="Kinetic law describes the reaction kinetics.")
public class KineticLaw
extends Option {
    protected String formula = "0";
    protected String timeUnits;
    protected String substanceUnits;
    protected String comment;

    public KineticLaw() {
    }

    public KineticLaw(String formula) {
        this.setFormula(formula);
    }

    public KineticLaw(Reaction parent) {
        this.setParent((Option)parent);
    }

    public KineticLaw(Reaction parent, KineticLaw original) {
        this.setParent((Option)parent);
        this.setComment(original.getComment());
        this.setFormula(original.getFormula());
        this.setSubstanceUnits(original.getSubstanceUnits());
        this.setTimeUnits(original.getTimeUnits());
    }

    @PropertyName(value="Formula")
    @PropertyDescription(value="Reaction rate formula.")
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.formula;
        this.formula = formula;
        this.firePropertyChange("formula", oldValue, formula);
    }

    @PropertyName(value="Time units")
    @PropertyDescription(value="Reaction rate time units.")
    public String getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(String timeUnits) {
        String oldValue = this.timeUnits;
        this.timeUnits = timeUnits;
        this.firePropertyChange("timeUnits", oldValue, timeUnits);
    }

    @PropertyName(value="Substance units")
    @PropertyDescription(value="Reaction rate substance units.")
    public String getSubstanceUnits() {
        return this.substanceUnits;
    }

    public void setSubstanceUnits(String substanceUnits) {
        String oldValue = this.substanceUnits;
        this.substanceUnits = substanceUnits;
        this.firePropertyChange("substanceUnits", oldValue, substanceUnits);
    }

    @PropertyName(value="Comment")
    @PropertyDescription(value="Comment on reaction rate.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String toString() {
        return this.getFormula();
    }
}

