/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.Module;
import biouml.model.Node;
import biouml.standard.type.CDKRenderer;
import biouml.standard.type.Structure;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import ru.biosoft.access.ImageDataElement;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.exception.Assert;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.util.DimensionEx;

public class ImageDescriptor
extends Option
implements ImageObserver,
PropertyChangeListener {
    static final Dimension DEFAULT_ORIGINAL_SIZE = new Dimension(-1, -1);
    protected static final Logger log = Logger.getLogger(ImageDescriptor.class.getName());
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private DataElementPath path;
    protected String source;
    private boolean isParentChanging = false;
    private DimensionEx scale = new DimensionEx((Option)this, 1, Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 100, 100);
    protected Dimension size = new Dimension();
    protected Dimension originalSize = new Dimension();
    protected Image image;
    protected CompositeView imageView = null;
    protected int loadStatus = 0;
    protected boolean initialised = false;
    protected boolean initialised2 = false;

    public ImageDescriptor() {
        this.scale.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ImageDescriptor(DataElementPath path) {
        this.path = path;
    }

    public ImageDescriptor(String source) {
        this(source, null);
    }

    public ImageDescriptor(String source, Dimension size) {
        this.source = source;
        this.size = size;
        if (this.size == null) {
            this.size = new Dimension();
        }
    }

    public Module getModule() {
        return Module.optModule((DataElement)this.getParent());
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        String oldValue = this.source;
        this.source = source;
        this.initialised = false;
        this.initialised2 = false;
        this.setSize(new Dimension(0, 0));
        this.loadImage();
        this.firePropertyChange("source", oldValue, source);
    }

    @Nonnull
    public Dimension getSize() {
        return new Dimension(this.size);
    }

    public void setSize(@Nonnull Dimension size) {
        Assert.notNull((String)"size", (Object)size);
        Dimension oldSize = this.size;
        this.size = size;
        this.firePropertyChange("size", oldSize, size);
    }

    @PropertyName(value="Original size")
    public Dimension getOriginalSize() {
        return new Dimension(this.size);
    }

    public void setOriginalSize(Dimension size) {
    }

    public Image getImage() {
        this.loadImage();
        if (this.image == null) {
            this.originalSize = DEFAULT_ORIGINAL_SIZE;
        }
        return this.image;
    }

    public CompositeView getImageView(Graphics2D g) {
        this.loadImageView(g);
        return this.imageView;
    }

    @Override
    public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
        System.out.println("imageUpdate: " + info + ", image=" + img + " " + width + "x" + height);
        return info != 32;
    }

    protected void loadImage() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        if (this.path != null) {
            ImageDataElement ide = (ImageDataElement)this.path.getDataElement(ImageDataElement.class);
            this.image = ide.getImage();
        } else if (this.source == null || this.source.length() == 0) {
            this.image = null;
        } else if (this.source.contains("Data/structure/")) {
            try {
                Structure structure = null;
                structure = this.source.startsWith("databases/") ? (Structure)CollectionFactory.getDataElement((String)this.source) : (Structure)CollectionFactory.getDataElement((String)this.source, (DataCollection)this.getModule());
                if (structure != null) {
                    this.image = CDKRenderer.createStructureImage(structure, this.size);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create structure view, source=" + this.source + ", error: " + t, t);
            }
        } else if (!this.source.startsWith("Dictionaries/image/")) {
            try {
                DataCollection idc = (DataCollection)this.getModule().get("Images");
                ImageDataElement ide = (ImageDataElement)idc.get(this.source);
                this.image = ide.getImage(null);
            }
            catch (Exception e) {
                this.image = null;
            }
        }
        if (this.image != null) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            if (DEFAULT_ORIGINAL_SIZE.equals(this.originalSize)) {
                this.size.width = imageWidth;
                this.size.height = imageHeight;
            }
            this.originalSize.width = imageWidth;
            this.originalSize.height = imageHeight;
            if (this.getParent() instanceof Node) {
                Dimension nodeSize = ((Node)this.getParent()).getShapeSize();
                this.scale.setWidth((int)(nodeSize.getWidth() / (double)imageWidth * 100.0));
                this.scale.setHeight((int)(nodeSize.getHeight() / (double)imageHeight * 100.0));
                ((Node)this.getParent()).setShapeSize(new Dimension((int)((double)(imageWidth * this.scale.getWidth()) / 100.0), (int)((double)(imageHeight * this.scale.getHeight()) / 100.0)));
            }
            this.firePropertyChange("originalSize", null, null);
            if (this.size.width == 0 || this.size.height == 0) {
                this.size.setSize(this.originalSize);
                this.firePropertyChange("size", null, null);
            }
        }
    }

    protected void loadImageView(Graphics2D g) {
        if (this.initialised2) {
            return;
        }
        this.initialised2 = true;
        if (this.source == null || this.source.length() == 0) {
            this.imageView = null;
        } else if (this.source.contains("Data/structure/")) {
            try {
                Structure structure = null;
                structure = this.source.startsWith("databases/") ? (Structure)CollectionFactory.getDataElement((String)this.source) : (Structure)CollectionFactory.getDataElement((String)this.source, (DataCollection)this.getModule());
                if (structure != null) {
                    this.imageView = CDKRenderer.createStructureView(structure, this.size, g);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create structure view, source=" + this.source + ", error: " + t, t);
            }
        }
    }

    public String[] getStructures(Module module) {
        ArrayList<String> structures = new ArrayList<String>();
        try {
            DataElementPath basePath = module.getCompletePath().getChildPath(new String[]{"Data", "structure"});
            for (DataElementPath structurePath : basePath.getChildren()) {
                structures.add(structurePath.toString());
            }
        }
        catch (Exception e) {
            return null;
        }
        return structures.toArray(new String[structures.size()]);
    }

    public String[] getImages() {
        Module module = this.getModule();
        if (!module.contains("Images")) {
            return null;
        }
        try {
            return (String[])((DataCollection)module.get("Images")).names().toArray(String[]::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addImage(BufferedImage image, String name) {
        try {
            DataCollection dc = (DataCollection)this.getModule().get("Images");
            if (dc != null) {
                dc.put((DataElement)new ImageDataElement(name, dc, image));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PropertyName(value="Image path")
    public DataElementPath getPath() {
        return this.path;
    }

    public void setPath(DataElementPath path) {
        this.initialised = false;
        DataElementPath oldValue = this.path;
        this.path = path;
        this.firePropertyChange("path", oldValue, path);
    }

    public ImageDescriptor clone() {
        ImageDescriptor result = new ImageDescriptor();
        if (this.getPath() != null) {
            result.setPath(this.getPath());
        }
        result.setSize(this.getSize());
        if (this.getSource() != null) {
            result.setSource(this.getSource());
        }
        return result;
    }

    @PropertyName(value="Image scale")
    public DimensionEx getScale() {
        return this.scale;
    }

    public void setScale(DimensionEx scale) {
        DimensionEx oldValue = scale;
        this.scale = scale;
        this.firePropertyChange("scale", oldValue, scale);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isParentChanging) {
            return;
        }
        if (evt.getSource() == this.getScale() && this.path != null && this.getParent() instanceof Node) {
            int scale;
            if (evt.getPropertyName().equals("width")) {
                scale = (Integer)evt.getNewValue();
                int nodeWidth = (int)((double)(this.getOriginalSize().width * scale) / 100.0);
                ((Node)this.getParent()).getShapeSize2().setWidth(nodeWidth);
            }
            if (evt.getPropertyName().equals("height")) {
                scale = (Integer)evt.getNewValue();
                int nodeHeight = (int)((double)(this.getOriginalSize().height * scale) / 100.0);
                ((Node)this.getParent()).getShapeSize2().setHeight(nodeHeight);
            }
        }
    }

    public void updateScale() {
        this.isParentChanging = true;
        Dimension imageSize = this.getOriginalSize();
        Dimension nodeSize = ((Node)this.getParent()).getShapeSize();
        this.scale.setWidth((int)(nodeSize.getWidth() / imageSize.getWidth() * 100.0));
        this.scale.setHeight((int)(nodeSize.getHeight() / imageSize.getHeight() * 100.0));
        this.isParentChanging = false;
    }
}

