/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import com.developmentontheedge.beans.Option;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.support.SerializableAsText;
import ru.biosoft.util.TextUtil;

public class DatabaseReference
extends Option
implements SerializableAsText {
    private static final long serialVersionUID = -4331440516388287611L;
    @Nonnull
    public static final DataElementPath STUB_PATH = DataElementPath.create((String)"stub");
    protected String databaseName;
    protected String databaseVersion;
    protected String id;
    protected String idVersion;
    protected String relationshipType;
    protected String ac;
    protected String comment;

    public DatabaseReference() {
    }

    public DatabaseReference(DatabaseReference original) {
        this.databaseName = original.databaseName;
        this.id = original.id;
        this.ac = original.ac;
        this.comment = original.comment;
        this.relationshipType = original.relationshipType;
    }

    public int hashCode() {
        return Objects.hash(this.ac, this.comment, this.databaseName, this.databaseVersion, this.id, this.idVersion, this.relationshipType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DatabaseReference other = (DatabaseReference)((Object)obj);
        return Objects.equals(this.ac, other.ac) && Objects.equals(this.comment, other.comment) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals(this.id, other.id) && Objects.equals(this.idVersion, other.idVersion) && Objects.equals(this.relationshipType, other.relationshipType);
    }

    public DatabaseReference(String text) {
        StringTokenizer tokens = new StringTokenizer(text, ";", true);
        this.databaseName = this.nextToken(tokens);
        this.id = this.nextToken(tokens);
        this.ac = this.nextToken(tokens);
        this.databaseVersion = this.nextToken(tokens);
        this.idVersion = this.nextToken(tokens);
        this.relationshipType = this.nextToken(tokens);
        if (tokens.hasMoreElements()) {
            this.comment = tokens.nextToken().replaceAll("^ ", "");
        }
        while (tokens.hasMoreElements()) {
            this.comment = this.comment + tokens.nextToken();
        }
    }

    public DatabaseReference(Element element) {
        if (!element.getElementPath().isDescendantOf(STUB_PATH)) {
            throw new IllegalArgumentException("Supplied element not supported: " + element);
        }
        String[] properties = element.getElementPath().getPathComponents();
        if (properties.length <= 3) {
            throw new IllegalArgumentException("Supplied element not supported: " + element);
        }
        this.setDatabaseName(properties[1]);
        this.setId(properties[2]);
        this.setAc(properties[3]);
    }

    public DatabaseReference(String dbName, String id, String acc) {
        this.setDatabaseName(dbName);
        this.setId(id);
        this.setAc(acc);
    }

    public DatabaseReference(String dbName, String id) {
        this(dbName, id, id);
    }

    protected String nextToken(StringTokenizer tokens) {
        String value = null;
        if (tokens.hasMoreElements()) {
            value = tokens.nextToken().trim();
            if (value.length() == 0 || value.equals(";") || value.equals("null")) {
                value = null;
            }
            if (tokens.hasMoreElements()) {
                tokens.nextToken();
            }
        }
        return value;
    }

    public String getAsText() {
        StringBuffer result = new StringBuffer();
        if (this.databaseName != null) {
            result.append(this.databaseName);
        }
        result.append("; ");
        if (this.id != null) {
            result.append(this.id);
        }
        result.append("; ");
        if (this.ac != null) {
            result.append(this.ac);
        }
        result.append("; ");
        if (this.databaseVersion != null) {
            result.append(this.databaseVersion);
        }
        result.append("; ");
        if (this.idVersion != null) {
            result.append(this.idVersion);
        }
        result.append("; ");
        if (this.relationshipType != null) {
            result.append(this.relationshipType);
        }
        result.append("; ");
        if (this.comment != null) {
            result.append(this.comment);
        }
        return result.toString();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        String oldValue = this.databaseName;
        this.databaseName = databaseName;
        this.firePropertyChange("databaseName", oldValue, databaseName);
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldValue = this.id;
        this.id = id;
        this.firePropertyChange("id", oldValue, id);
    }

    public String getIdVersion() {
        return this.idVersion;
    }

    public void setIdVersion(String idVersion) {
        this.idVersion = idVersion;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        String oldValue = this.relationshipType;
        this.relationshipType = relationshipType;
        this.firePropertyChange("relationshipType", oldValue, relationshipType);
    }

    public String getAc() {
        return this.ac;
    }

    public void setAc(String ac) {
        String oldValue = this.ac;
        this.ac = ac;
        this.firePropertyChange("ac", oldValue, ac);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String toString() {
        return "" + this.getDatabaseName() + ": " + this.getId() + ", " + this.getRelationshipType() + (this.getAc() == null ? "" : " (" + this.getAc() + ")") + (this.getComment() == null ? "" : "; " + this.getComment());
    }

    public Element convertToElement() {
        return new Element(STUB_PATH.getChildPath(new String[]{this.getDatabaseName(), TextUtil.nullToEmpty((String)this.getId()), TextUtil.nullToEmpty((String)this.getAc())}));
    }
}

