/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Structure;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.PathElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;
import ru.biosoft.access.exception.BiosoftParseException;
import ru.biosoft.access.security.SecurityManager;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.EllipseView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.PathView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class CDKRenderer {
    public static double[] getBounds(IAtomContainer molecule) {
        double[] minMax = GeometryTools.getMinMax((IAtomContainer)molecule);
        if (minMax[2] == minMax[0]) {
            minMax[2] = minMax[2] + 1.0;
        }
        if (minMax[3] == minMax[1]) {
            minMax[3] = minMax[3] + 1.0;
        }
        return new double[]{minMax[2] - minMax[0], minMax[3] - minMax[1]};
    }

    protected static void renderImage(Structure structure, Dimension size, Graphics2D g, CompositeView result) {
        Rectangle drawArea = new Rectangle(size.width, size.height);
        IMolecule molecule = CDKRenderer.loadMolecule(structure);
        if (size.width <= 0 || size.height <= 0) {
            size.setSize(GeometryTools.get2DDimension((IAtomContainer)molecule));
        }
        double[] bounds = CDKRenderer.getBounds((IAtomContainer)molecule);
        double scaleX = size.getWidth() * 0.9 / bounds[0];
        double scaleY = size.getHeight() * 0.9 / bounds[1];
        GeometryTools.scaleMolecule((IAtomContainer)molecule, (double)Math.min(scaleX, scaleY));
        GeometryTools.center((IAtomContainer)molecule, (Dimension)size);
        ArrayList<Object> generators = new ArrayList<Object>();
        generators.add(new BasicSceneGenerator());
        generators.add(new BasicBondGenerator());
        generators.add(new BasicAtomGenerator());
        AtomContainerRenderer renderer = new AtomContainerRenderer(generators, (IFontManager)new AWTFontManager());
        renderer.setDrawCenter(drawArea.getCenterX(), drawArea.getCenterY());
        renderer.setModelCenter(drawArea.getCenterX(), drawArea.getCenterY());
        ((BasicSceneGenerator.Scale)renderer.getRenderer2DModel().getParameter(BasicSceneGenerator.Scale.class)).setValue((Object)1.0);
        renderer.paint((IAtomContainer)molecule, (IDrawVisitor)(result == null ? new AWTDrawVisitor(g) : new CompositeViewDrawVisitor(result, g)));
    }

    public static IMolecule loadMolecule(Structure structure) throws BiosoftParseException {
        try {
            String structureData = CDKRenderer.convertDataForCDKReader(structure.getData());
            PrintStream oldError = System.err;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream newError = new PrintStream(baos);
            IMolecule molecule = null;
            try {
                molecule = (IMolecule)SecurityManager.runPrivileged(() -> {
                    Molecule mol;
                    System.setErr(newError);
                    try {
                        MDLReader mdl = new MDLReader((Reader)new StringReader(structureData));
                        mol = (Molecule)mdl.read((IChemObject)new Molecule());
                        if (!GeometryTools.has2DCoordinates((IAtomContainer)mol)) {
                            try {
                                StructureDiagramGenerator sdg = new StructureDiagramGenerator();
                                sdg.setMolecule((IMolecule)mol);
                                sdg.generateCoordinates();
                                mol = sdg.getMolecule();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        System.setErr(oldError);
                    }
                    return mol;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (baos.size() > 0) {
                throw new CDKException(new String(baos.toByteArray(), StandardCharsets.ISO_8859_1));
            }
            return molecule;
        }
        catch (CDKException e) {
            throw new BiosoftParseException((Throwable)e, structure.getName());
        }
    }

    private static String convertDataForCDKReader(String data) {
        String structureData = data;
        if (structureData.startsWith("  ")) {
            structureData = "\n" + structureData;
        }
        return structureData;
    }

    public static BufferedImage createStructureImage(Structure structure, Dimension size) throws Exception {
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, size.width, size.height);
        CDKRenderer.renderImage(structure, size, g2, null);
        return image;
    }

    @Nonnull
    public static CompositeView createStructureView(Structure structure, Dimension size, Graphics2D g) throws Exception {
        CompositeView result = new CompositeView();
        CDKRenderer.renderImage(structure, size, g, result);
        Rectangle bounds = result.getBounds();
        result.move(-bounds.x, -bounds.y);
        return result;
    }

    public static class CompositeViewDrawVisitor
    implements IDrawVisitor {
        private AWTFontManager fontManager;
        protected CompositeView parentView;
        protected BasicStroke stroke;
        protected Graphics2D g;
        protected AffineTransform transform = null;

        public CompositeViewDrawVisitor(CompositeView parentView, Graphics2D g) {
            this.parentView = parentView;
            this.g = g;
            this.fontManager = null;
            this.stroke = new BasicStroke(0.5f);
        }

        public void visit(IRenderingElement element) {
            if (element instanceof ElementGroup) {
                this.visit((ElementGroup)element);
            } else if (element instanceof WedgeLineElement) {
                this.visit((WedgeLineElement)element);
            } else if (element instanceof LineElement) {
                this.visit((LineElement)element);
            } else if (element instanceof ArrowElement) {
                this.visit((ArrowElement)element);
            } else if (element instanceof OvalElement) {
                this.visit((OvalElement)element);
            } else if (element instanceof TextGroupElement) {
                this.visit((TextGroupElement)element);
            } else if (element instanceof AtomSymbolElement) {
                this.visit((AtomSymbolElement)element);
            } else if (element instanceof TextElement) {
                this.visit((TextElement)element);
            } else if (element instanceof RectangleElement) {
                this.visit((RectangleElement)element);
            } else if (element instanceof PathElement) {
                this.visit((PathElement)element);
            } else {
                System.err.println("Visitor method for " + element.getClass().getName() + " is not implemented");
            }
        }

        public void setFontManager(IFontManager fontManager) {
            this.fontManager = (AWTFontManager)fontManager;
        }

        public void setRendererModel(RendererModel rendererModel) {
        }

        public void setTransform(AffineTransform transform) {
            this.transform = transform;
        }

        public Point transformPoint(double x, double y) {
            double[] src = new double[]{x, y};
            double[] dest = new double[2];
            this.transform.transform(src, 0, dest, 0, 1);
            return new Point((int)dest[0], (int)dest[1]);
        }

        protected void visit(ElementGroup elementGroup) {
            elementGroup.visitChildren((IRenderingVisitor)this);
        }

        protected void visit(ArrowElement line) {
            Pen pen = new Pen((float)line.width, line.color);
            Brush brush = new Brush((Paint)line.color);
            Point start = this.transformPoint(line.x1, line.y1);
            Point end = this.transformPoint(line.x2, line.y2);
            ArrowView.Tip startTip = null;
            ArrowView.Tip endTip = null;
            if (line.direction) {
                startTip = ArrowView.createArrowTip((Pen)pen, (Brush)brush, (int)6, (int)6, (int)4);
            } else {
                endTip = ArrowView.createArrowTip((Pen)pen, (Brush)brush, (int)6, (int)6, (int)4);
            }
            ArrowView view = new ArrowView(pen, brush, start.x, start.y, end.x, end.y, startTip, endTip);
            this.parentView.add((View)view);
        }

        protected void visit(LineElement line) {
            Pen pen = new Pen(this.stroke, line.color);
            Brush brush = new Brush((Paint)line.color);
            Point start = this.transformPoint(line.x1, line.y1);
            Point end = this.transformPoint(line.x2, line.y2);
            ArrowView view = new ArrowView(pen, brush, start.x, start.y, end.x, end.y, null, null);
            this.parentView.add((View)view);
        }

        protected void visit(OvalElement oval) {
            Pen pen = new Pen(this.stroke, oval.color);
            Brush brush = null;
            if (oval.fill) {
                brush = new Brush((Paint)oval.color);
            }
            Point min = this.transformPoint(oval.x - oval.radius, oval.y - oval.radius);
            Point max = this.transformPoint(oval.x + oval.radius, oval.y + oval.radius);
            int w = max.x - min.x;
            int h = max.y - min.y;
            EllipseView view = new EllipseView(pen, brush, (float)(min.x + w / 2), (float)(min.y + h / 2), (float)w, (float)h);
            this.parentView.add((View)view);
        }

        protected void visit(TextElement textElement) {
            Point location = this.transformPoint(textElement.x, textElement.y);
            CompositeView text = new CompositeView();
            ColorFont colorFont = new ColorFont(this.fontManager.getFont(), textElement.color);
            TextView textView = new TextView(textElement.text, colorFont, (Graphics)this.g);
            Rectangle bounds = textView.getBounds();
            location = new Point(location.x - bounds.width / 2, location.y - bounds.height / 2);
            BoxView back = new BoxView(null, new Brush((Paint)Color.white), bounds);
            text.add((View)back);
            text.add((View)textView);
            text.setLocation(location);
            this.parentView.add((View)text);
        }

        protected void visit(WedgeLineElement wedge) {
            Brush brush = new Brush((Paint)wedge.color);
            Point start = this.transformPoint(wedge.x1, wedge.y1);
            Point end = this.transformPoint(wedge.x2, wedge.y2);
            int length = (int)Math.sqrt((start.x - end.x) * (start.x - end.x) + (start.y - end.y) * (start.y - end.y));
            ArrowView view = null;
            if (wedge.isDashed) {
                BasicStroke stroke2 = new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
                Pen pen = new Pen(stroke2, wedge.color);
                view = new LineView(pen, (float)start.x, (float)start.y, (float)end.x, (float)end.y);
            } else {
                Pen pen = new Pen(this.stroke, wedge.color);
                view = new ArrowView(pen, brush, start.x, start.y, end.x, end.y, ArrowView.createArrowTip((Pen)pen, (Brush)brush, (int)length, (int)length, (int)2), null);
            }
            this.parentView.add((View)view);
        }

        protected void visit(AtomSymbolElement atomSymbol) {
            Point location = this.transformPoint(atomSymbol.x, atomSymbol.y);
            CompositeView text = new CompositeView();
            ColorFont colorFont = new ColorFont(this.fontManager.getFont(), atomSymbol.color);
            TextView textView = new TextView(atomSymbol.text, colorFont, (Graphics)this.g);
            Rectangle bounds = textView.getBounds();
            location = new Point(location.x - bounds.width / 2, location.y - bounds.height / 2);
            BoxView back = new BoxView(null, new Brush((Paint)Color.white), bounds);
            text.add((View)back);
            text.add((View)textView);
            text.setLocation(location);
            this.parentView.add((View)text);
        }

        protected void visit(RectangleElement rectangle) {
            Point p1 = this.transformPoint(rectangle.x, rectangle.y);
            Point p2 = this.transformPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            Pen pen = new Pen(this.stroke, rectangle.color);
            Brush brush = null;
            if (rectangle.filled) {
                brush = new Brush((Paint)rectangle.color);
            }
            BoxView view = new BoxView(pen, brush, p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
            this.parentView.add((View)view);
        }

        protected void visit(PathElement path) {
            Pen pen = new Pen(this.stroke, path.color);
            ArrayList points = path.points;
            if (points.size() > 0) {
                GeneralPath generalPath = new GeneralPath();
                Point start = (Point)points.get(0);
                generalPath.moveTo(start.x, start.y);
                for (int i = 1; i < points.size(); ++i) {
                    Point p = (Point)points.get(i);
                    generalPath.lineTo(p.x, p.y);
                }
                PathView view = new PathView(pen, generalPath);
                this.parentView.add((View)view);
            }
        }

        protected void visit(TextGroupElement textGroup) {
            Point location = this.transformPoint(textGroup.x, textGroup.y);
            CompositeView text = new CompositeView();
            ColorFont colorFont = new ColorFont(this.fontManager.getFont(), textGroup.color);
            TextView textView = new TextView(textGroup.text, colorFont, (Graphics)this.g);
            Rectangle bounds = textView.getBounds();
            location = new Point(location.x - bounds.width / 2, location.y - bounds.height / 2);
            BoxView back = new BoxView(null, new Brush((Paint)Color.white), bounds);
            text.add((View)back);
            text.add((View)textView);
            text.setLocation(location);
            this.parentView.add((View)text);
        }
    }
}

