/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.Molecule;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.core.DataCollection;

public abstract class Biopolymer
extends Molecule {
    private String species;
    private String source;
    private String regulation;

    protected Biopolymer(DataCollection<?> origin, String name) {
        super(origin, name);
    }

    @PropertyName(value="Species")
    @PropertyDescription(value="Organism Species.<br>In most cases this is done by giving the Latin genus and species designations, followed (in parentheses) by the common name in English where known.<p>The format is:<pre>Genus species (name)</pre>Example:<pre>Homo sapiens (human)</pre>")
    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        String oldValue = this.species;
        this.species = species;
        this.firePropertyChange("species", oldValue, species);
    }

    @PropertyName(value="Source")
    @PropertyDescription(value="Cell line (it also may be cell, tissue or organ) where an expression of the gene, RNA or protein was registered.<p>The format is:<pre>cell identifier</pre>")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        String oldValue = this.source;
        this.source = source;
        this.firePropertyChange("source", oldValue, source);
    }

    @PropertyName(value="Regulation")
    @PropertyDescription(value="List of factors regulating this component.")
    public String getRegulation() {
        return this.regulation;
    }

    public void setRegulation(String regulation) {
        String oldValue = this.regulation;
        this.regulation = regulation;
        this.firePropertyChange("regulation", oldValue, regulation);
    }
}

