/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.standard.state.State;
import biouml.standard.state.StateTabListener;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class StatesTab
extends JPanel {
    protected Diagram diagram;
    protected TabularPropertyInspector table;
    protected StateTabListener tabListener;

    public StatesTab(StateTabListener listener) {
        this.tabListener = listener;
        this.setLayout(new BorderLayout());
        this.table = new TabularPropertyInspector();
        this.table.getTable().setSelectionMode(0);
        this.add((Component)this.table, "Center");
        this.table.explore((Object[])new State[0]);
        this.table.addListSelectionListener(event -> {
            Object model;
            if (event.getFirstIndex() != -1 && (model = this.table.getModelOfSelectedRow()) instanceof State) {
                this.tabListener.setCurrentState((State)model);
            }
        });
    }

    public void refresh(Diagram diagram) {
        this.diagram = diagram;
        this.table.explore(diagram.states().toArray());
    }

    protected void changeState(State state) {
        Object model = this.table.getModelOfSelectedRow();
        if (model instanceof State && model != state) {
            this.refresh(this.diagram);
        }
        int i = (int)this.diagram.states().indexOf((Object)state).orElse(0L);
        this.table.getTable().getSelectionModel().setSelectionInterval(i, i);
    }
}

