/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.standard.state.ChangesTab;
import biouml.standard.state.MessageBundle;
import biouml.standard.state.NewStateDialog;
import biouml.standard.state.State;
import biouml.standard.state.StateTabListener;
import biouml.standard.state.StatesTab;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.beans.undo.Transactable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.gui.Document;
import ru.biosoft.util.ApplicationUtils;

public class StatesPane
extends JPanel
implements StateTabListener {
    public static final String APPLY = "apply";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String REMOVE_TRANSACTION = "remove_transaction";
    protected ApplyAction applyAction = new ApplyAction("apply");
    protected AddAction addAction = new AddAction("add");
    protected RemoveAction removeAction = new RemoveAction("remove", this);
    protected RemoveTransactionAction removeTransactionAction = new RemoveTransactionAction("remove_transaction", this);
    protected Action[] actions;
    protected Diagram diagram;
    protected Document document;
    protected JTabbedPane tabbedPane;
    protected StatesTab statesTab;
    protected ChangesTab changesTab;
    public static final String STATES = "States";
    public static final String CHANGES = "Changes";
    protected MessageBundle messageBundle = new MessageBundle();
    protected State currentState = null;
    private PropertyChangeListener diagramListener;

    public StatesPane() {
        this.setLayout(new BorderLayout());
        this.statesTab = new StatesTab(this);
        this.changesTab = new ChangesTab(this);
        this.tabbedPane = new JTabbedPane(2);
        this.tabbedPane.add(STATES, this.statesTab);
        this.tabbedPane.add(CHANGES, this.changesTab);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(e -> {
            int index = this.tabbedPane.getSelectedIndex();
            if (index == 1) {
                this.changesTab.changeState(this.currentState);
            }
        });
        this.initListeners();
    }

    protected void initListeners() {
        this.diagramListener = evt -> {
            if (evt.getPropertyName().equals("currentStateName")) {
                if (this.diagram.getCurrentState() == null) {
                    this.applyAction.setSelected(false);
                } else {
                    if (!this.diagram.containState(this.diagram.getCurrentState())) {
                        return;
                    }
                    this.setCurrentState(this.diagram.getCurrentState());
                    this.applyAction.setSelected(true);
                }
            } else if (evt.getPropertyName().equals("states")) {
                this.statesTab.refresh(this.diagram);
                this.changesTab.refresh(this.diagram);
            }
        };
    }

    public void explore(Diagram diagram, Document document) {
        this.diagram = diagram;
        this.document = document;
        this.statesTab.refresh(diagram);
        this.changesTab.refresh(diagram);
        this.currentState = diagram.getCurrentState();
        if (this.currentState == null) {
            this.applyAction.setSelected(false);
        } else {
            this.applyAction.setSelected(true);
        }
        diagram.removePropertyChangeListener(this.diagramListener);
        diagram.addPropertyChangeListener(this.diagramListener);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
            initializer.initAction((Action)this.applyAction, APPLY);
            initializer.initAction((Action)this.addAction, ADD);
            initializer.initAction((Action)this.removeAction, REMOVE);
            initializer.initAction((Action)this.removeTransactionAction, REMOVE_TRANSACTION);
            this.actions = new Action[]{this.applyAction, this.addAction, this.removeAction, this.removeTransactionAction};
        }
        return this.actions;
    }

    public boolean applyCurrentState() {
        if (this.currentState != null) {
            this.diagram.setStateEditingMode(this.currentState, (Transactable)((ViewEditorPane)this.document.getViewPane()));
            this.document.update();
            return true;
        }
        return false;
    }

    public void restoreDiagram() {
        this.diagram.restore();
        this.document.update();
    }

    @Override
    public void setCurrentState(State state) {
        this.currentState = state;
        this.statesTab.changeState(state);
        this.changesTab.changeState(state);
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    class RemoveTransactionAction
    extends AbstractAction {
        protected StatesPane statesPane;

        public RemoveTransactionAction(String name, StatesPane statesPane) {
            super(name);
            this.statesPane = statesPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = StatesPane.this.changesTab.getChangesTable().getTable();
            if (StatesPane.this.currentState == null || StatesPane.this.tabbedPane.getSelectedIndex() != 1 || table.getSelectedRowCount() == 0) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this.statesPane, "Do you really want to delete selected transaction(s)?", "Remove transaction...", 2) == 0) {
                if (StatesPane.this.diagram.getCurrentState() == StatesPane.this.currentState) {
                    StatesPane.this.restoreDiagram();
                    StatesPane.this.applyAction.setSelected(false);
                }
                for (int i = table.getRowCount() - 1; i >= 0; --i) {
                    if (!table.isRowSelected(i)) continue;
                    StatesPane.this.currentState.getStateUndoManager().removeEdit(i);
                }
                StatesPane.this.statesTab.refresh(StatesPane.this.diagram);
                StatesPane.this.changesTab.refresh(StatesPane.this.diagram);
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        protected StatesPane statesPane;

        public RemoveAction(String name, StatesPane statesPane) {
            super(name);
            this.statesPane = statesPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StatesPane.this.currentState != null && JOptionPane.showConfirmDialog(this.statesPane, "Do you really want to delete state '" + StatesPane.this.currentState.getName() + "'", "State deleting...", 2) == 0) {
                if (StatesPane.this.diagram.getCurrentState() == StatesPane.this.currentState) {
                    StatesPane.this.restoreDiagram();
                    StatesPane.this.applyAction.setSelected(false);
                }
                StatesPane.this.diagram.removeState(StatesPane.this.currentState);
                StatesPane.this.currentState = null;
                StatesPane.this.statesTab.refresh(StatesPane.this.diagram);
                StatesPane.this.changesTab.refresh(StatesPane.this.diagram);
            }
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewStateDialog dialog = new NewStateDialog("New state", StatesPane.this.diagram);
            if (dialog.doModal()) {
                State newState = dialog.getNewDiagramElement();
                StatesPane.this.diagram.addState(newState);
                StatesPane.this.statesTab.refresh(StatesPane.this.diagram);
                StatesPane.this.changesTab.refresh(StatesPane.this.diagram);
                if (StatesPane.this.diagram.getCurrentState() == null) {
                    StatesPane.this.applyAction.setSelected(true);
                    StatesPane.this.setCurrentState(newState);
                    StatesPane.this.applyCurrentState();
                }
            }
        }
    }

    class ApplyAction
    extends AbstractAction {
        protected boolean selected;

        public ApplyAction(String name) {
            super(name);
            this.selected = false;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.refreshButton(selected);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selected) {
                StatesPane.this.restoreDiagram();
                this.selected = false;
            } else if (StatesPane.this.applyCurrentState()) {
                this.selected = true;
            }
            this.refreshButton(this.selected);
        }

        protected void refreshButton(boolean selected) {
            String descString;
            String iconString;
            if (selected) {
                iconString = StatesPane.this.messageBundle.getResourceString("applySmallIcon2");
                descString = StatesPane.this.messageBundle.getResourceString("applyShortDescription2");
            } else {
                iconString = StatesPane.this.messageBundle.getResourceString("applySmallIcon");
                descString = StatesPane.this.messageBundle.getResourceString("applyShortDescription");
            }
            this.putValue("ShortDescription", descString);
            URL url = this.getClass().getResource("resources/" + iconString);
            if (url != null) {
                this.putValue("SmallIcon", ApplicationUtils.getImageIcon((URL)url));
            }
        }
    }
}

