/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.state.TransactionUtils;
import com.developmentontheedge.beans.undo.TransactionUndoManager;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;

public class StateUndoManager
extends TransactionUndoManager {
    private static final Logger log = Logger.getLogger(StateUndoManager.class.getName());
    protected boolean canUndo = false;
    protected boolean canRedo = false;
    protected boolean isUndo = false;
    protected boolean isRedo = false;

    public StateUndoManager() {
        this.setLimit(Integer.MAX_VALUE);
    }

    public synchronized boolean addEdit(UndoableEdit anEdit) {
        UndoableEdit lastEdit;
        this.canUndo = true;
        if (this.currentTransaction != null && this.currentTransaction.getEdits().size() > 0 && (lastEdit = (UndoableEdit)this.currentTransaction.getEdits().get(this.currentTransaction.getEdits().size() - 1)) instanceof StatePropertyChangeUndo && anEdit instanceof StatePropertyChangeUndo) {
            StatePropertyChangeUndo first = (StatePropertyChangeUndo)anEdit;
            StatePropertyChangeUndo second = (StatePropertyChangeUndo)lastEdit;
            if (first.getSource().equals(second.getSource()) && first.getPropertyName().equals(second.getPropertyName()) && first.getNewValue().equals(second.getNewValue()) && (first.getOldValue() == null && second.getOldValue() == null || first.getOldValue().equals(second.getOldValue()))) {
                return false;
            }
        }
        return super.addEdit(anEdit);
    }

    public synchronized void undo() throws CannotUndoException {
        this.completeTransaction();
        this.isUndo = true;
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            UndoableEdit edit = (UndoableEdit)this.edits.elementAt(i);
            if (edit == null) {
                log.warning("Undoing state: edit#" + i + " is absent. Result might be incorrect.");
                continue;
            }
            if (!edit.canUndo()) continue;
            try {
                edit.undo();
                continue;
            }
            catch (CannotUndoException e) {
                log.warning("Undoing state: edit#" + i + " (" + edit.getPresentationName() + ") was failed to undo. Edit was deleted.");
            }
        }
        if (this.edits.size() > 0) {
            this.canRedo = true;
        }
        this.canUndo = false;
        this.isUndo = false;
    }

    public synchronized void redo() throws CannotRedoException {
        this.completeTransaction();
        this.isRedo = true;
        for (int i = 0; i < this.edits.size(); ++i) {
            UndoableEdit edit = (UndoableEdit)this.edits.elementAt(i);
            if (edit == null) {
                log.warning("Redoing state: edit#" + i + " is absent. Result might be incorrect.");
                continue;
            }
            if (edit.canRedo()) {
                try {
                    edit.redo();
                }
                catch (CannotRedoException e) {
                    log.warning("Redoing state: edit#" + i + " (" + edit.getPresentationName() + ") was failed to redo. Edit was deleted.");
                    this.edits.remove(i);
                    --i;
                }
                continue;
            }
            this.edits.remove(i);
            --i;
        }
        if (this.edits.size() > 0) {
            this.canUndo = true;
        }
        this.canRedo = false;
        this.isRedo = false;
    }

    public synchronized void undoDeleted() throws CannotUndoException {
        List<UndoableEdit> edits = this.getEditsFlat();
        for (int i = edits.size() - 1; i >= 0; --i) {
            try {
                UndoableEdit edit = edits.get(i);
                if (edit == null || !edit.getClass().getName().equals(DataCollectionRemoveUndo.class.getName())) continue;
                edit.undo();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void redoDeleted() throws CannotRedoException {
        List<UndoableEdit> edits = this.getEditsFlat();
        for (int i = 0; i < edits.size(); ++i) {
            try {
                UndoableEdit edit = edits.get(i);
                if (edit == null || !edit.getClass().getName().equals(DataCollectionRemoveUndo.class.getName())) continue;
                edit.redo();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean canRedo() {
        return this.canRedo;
    }

    public synchronized boolean canUndo() {
        return this.canUndo;
    }

    public synchronized boolean isRedo() {
        return this.isRedo;
    }

    public synchronized boolean isUndo() {
        return this.isUndo;
    }

    public List<UndoableEdit> getEditsFlat() {
        StreamEx edits = StreamEx.of((Collection)this.getEdits()).flatMap(TransactionUtils::editsFlat);
        if (this.currentTransaction != null) {
            edits = (StreamEx)edits.append(TransactionUtils.editsFlat((UndoableEdit)this.currentTransaction));
        }
        return edits.toList();
    }

    public void removeEdit(int i) {
        this.edits.remove(i);
    }
}

