/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.model.util.DiagramXmlReader;
import biouml.model.util.DiagramXmlWriter;
import biouml.standard.state.DiagramStateUtility;
import biouml.standard.state.State;
import biouml.standard.state.StateXmlSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.AbstractFileTransformer;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.exception.BiosoftCustomException;
import ru.biosoft.exception.InternalException;

public class StateTransformer
extends AbstractFileTransformer<State> {
    public Class<State> getOutputType() {
        return State.class;
    }

    public State load(File input, String name, DataCollection<State> origin) throws Exception {
        try (FileInputStream fis = new FileInputStream(input);){
            State state;
            DiagramXmlReader reader = new DiagramXmlReader(name, fis, null);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fis);
            Element stateElement = document.getDocumentElement();
            if (stateElement == null) {
                throw new InternalException("Document element missing");
            }
            String diagramName = stateElement.getAttribute("diagram");
            if (diagramName == null) {
                throw new BiosoftCustomException(null, "Parse error: diagram is missing");
            }
            Diagram de = (Diagram)DataElementPath.create((String)diagramName).getDataElement(Diagram.class);
            reader.setDiagram(de);
            State state2 = state = StateXmlSerializer.readXmlElement(origin, stateElement, de, reader);
            return state2;
        }
    }

    public void save(File output, State state) throws Exception {
        Diagram diagram = DiagramStateUtility.getNativeDiagram(state);
        if (diagram == null) {
            throw new InternalException("Diagram for state is missing");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        try (FileOutputStream stream = new FileOutputStream(output);){
            DiagramXmlWriter diagramWriter = new DiagramXmlWriter(doc, diagram);
            Element stateElement = StateXmlSerializer.getStateXmlElement(state, doc, diagramWriter);
            stateElement.setAttribute("diagram", DataElementPath.create((DataElement)diagram).toString());
            doc.appendChild(stateElement);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
    }
}

