/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import java.beans.PropertyChangeEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import ru.biosoft.util.BeanUtil;

public class StatePropertyChangeUndo
extends AbstractUndoableEdit {
    private Object oldValue;
    private final PropertyChangeEvent pce;

    public StatePropertyChangeUndo(PropertyChangeEvent pce) {
        this.pce = pce;
        this.oldValue = pce.getOldValue();
    }

    public StatePropertyChangeUndo(Object source, String propertyName, Object oldValue, Object newValue) {
        this(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            super.undo();
            BeanUtil.setBeanPropertyValue((Object)this.pce.getSource(), (String)this.pce.getPropertyName(), (Object)this.oldValue);
        }
        catch (Exception e) {
            throw new CannotUndoException();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            this.oldValue = BeanUtil.getBeanPropertyValue((Object)this.pce.getSource(), (String)this.pce.getPropertyName());
            super.redo();
            BeanUtil.setBeanPropertyValue((Object)this.pce.getSource(), (String)this.pce.getPropertyName(), (Object)this.pce.getNewValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getPresentationName() {
        return "Change property '" + this.pce.getPropertyName() + "' of '" + this.pce.getSource() + "'";
    }

    public String getPropertyName() {
        return this.pce.getPropertyName();
    }

    public Object getNewValue() {
        return this.pce.getNewValue();
    }

    public Object getOldValue() {
        return this.pce.getOldValue();
    }

    public Object getSource() {
        return this.pce.getSource();
    }
}

