/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Compartment;
import biouml.model.DefaultDiagramViewBuilder;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.diagram.PathwayDiagramViewBuilder;
import biouml.standard.diagram.PathwaySimulationDiagramViewBuilder;
import biouml.standard.state.State;
import biouml.standard.state.StatePropertyChangeUndo;
import com.developmentontheedge.beans.Option;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.LineView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class StateDiagramViewBuilder
extends PathwaySimulationDiagramViewBuilder {
    protected State state;
    protected Diagram diagram;
    protected ColorFont titleFont = new ColorFont("Arial", 1, 18, Color.red);
    protected int titleAlignment = 31;
    protected Pen redPen = new Pen(2.0f, Color.red);
    protected Pen greenPen = new Pen(2.0f, Color.green);
    protected Pen bigRedPen = new Pen(7.0f, Color.red);
    protected Pen orangePen = new Pen(2.0f, Color.orange);
    private static final int STATUS_NONE = 0;
    private static final int STATUS_ADDED = 1;
    private static final int STATUS_REMOVED = 2;
    private static final int STATUS_CHANGED = 3;

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return this.baseViewBuilder.createDefaultDiagramViewOptions();
    }

    public StateDiagramViewBuilder(DiagramViewBuilder baseViewBuilder, State state, Diagram diagram) {
        this.baseViewBuilder = baseViewBuilder;
        this.state = state;
        this.diagram = diagram;
    }

    public DiagramViewBuilder getBaseViewBuilder() {
        return this.baseViewBuilder;
    }

    @Override
    public void setBaseViewBuilder(DiagramViewBuilder baseViewBuilder) {
        this.baseViewBuilder.setBaseViewBuilder(baseViewBuilder);
    }

    @Override
    public void setTypeMapping(Map<Object, String> typeMapping) {
        this.baseViewBuilder.setTypeMapping(typeMapping);
    }

    @Override
    @Nonnull
    public CompositeView createDiagramView(Diagram diagram, Graphics g) {
        boolean notificationEnabled = diagram.isNotificationEnabled();
        boolean propagationEnabled = diagram.isPropagationEnabled();
        diagram.setNotificationEnabled(false);
        diagram.setPropagationEnabled(false);
        this.state.getStateUndoManager().undoDeleted();
        CompositeView result = super.createDiagramView(diagram, g);
        if (this.baseViewBuilder instanceof PathwayDiagramViewBuilder) {
            ((PathwayDiagramViewBuilder)this.baseViewBuilder).createReactionTitles(diagram, result, diagram.getViewOptions(), g);
        }
        TextView title = new TextView(this.state.getName(), this.titleFont, g);
        result.add((View)title, this.titleAlignment, new Point(5, -60));
        diagram.setNotificationEnabled(false);
        diagram.setPropagationEnabled(false);
        this.state.getStateUndoManager().redoDeleted();
        diagram.setNotificationEnabled(notificationEnabled);
        diagram.setPropagationEnabled(propagationEnabled);
        return result;
    }

    @Override
    @Nonnull
    public CompositeView createNodeView(Node node, DiagramViewOptions options, Graphics g) {
        CompositeView result = this.baseViewBuilder.createNodeView(node, options, g);
        this.decorateNodeView(node, result);
        return result;
    }

    private void decorateNodeView(Node node, CompositeView result) {
        if (node instanceof Diagram) {
            return;
        }
        int elementStatus = this.getStatus(node);
        if (elementStatus == 2) {
            result.setPen(this.redPen);
            result.add((View)new LineView(this.bigRedPen, -10.0f, -10.0f, 10.0f, 10.0f), 127);
            result.add((View)new LineView(this.bigRedPen, -10.0f, 10.0f, 10.0f, -10.0f), 127);
        } else if (elementStatus == 1) {
            result.setPen(this.greenPen);
            CompositeView plusView = new CompositeView();
            plusView.add((View)new LineView(this.redPen, 0.0f, 5.0f, 10.0f, 5.0f));
            plusView.add((View)new LineView(this.redPen, 5.0f, 0.0f, 5.0f, 10.0f));
            result.add((View)plusView, 27);
        } else if (elementStatus == 3) {
            result.setPen(this.orangePen);
        }
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions options, Graphics g) {
        int elementStatus = this.getStatus(edge);
        CompositeView result = this.baseViewBuilder.createEdgeView(edge, options, g);
        if (elementStatus == 1) {
            result.setPen(this.greenPen);
        } else if (elementStatus == 3) {
            result.setPen(this.orangePen);
        } else if (elementStatus == 2) {
            result.setPen(this.redPen);
        }
        return result;
    }

    @Override
    @Nonnull
    public CompositeView createCompartmentView(Compartment compartment, DiagramViewOptions options, Graphics g) {
        CompositeView result = super.createCompartmentView(compartment, options, g);
        this.decorateNodeView(compartment, result);
        return result;
    }

    @Override
    public boolean createCompartmentCoreView(CompositeView container, Compartment compartment, DiagramViewOptions options, Graphics g) {
        if (this.baseViewBuilder instanceof DefaultDiagramViewBuilder) {
            return ((DefaultDiagramViewBuilder)this.baseViewBuilder).createCompartmentCoreView(container, compartment, options, g);
        }
        return super.createCompartmentCoreView(container, compartment, options, g);
    }

    protected int getStatus(DiagramElement de) {
        boolean isChanged = false;
        List<UndoableEdit> edits = this.state.getStateUndoManager().getEditsFlat();
        for (int i = edits.size() - 1; i >= 0; --i) {
            UndoableEdit ce = edits.get(i);
            if (ce instanceof DataCollectionAddUndo) {
                if (((DataCollectionAddUndo)ce).getDataElement() != de) continue;
                return 1;
            }
            if (ce instanceof DataCollectionRemoveUndo) {
                if (((DataCollectionRemoveUndo)ce).getDataElement() != de) continue;
                return 2;
            }
            if (!(ce instanceof StatePropertyChangeUndo) || ((StatePropertyChangeUndo)ce).getSource() != de && ((StatePropertyChangeUndo)ce).getSource() != de.getRole()) continue;
            isChanged = true;
        }
        if (isChanged) {
            return 3;
        }
        return 0;
    }

    protected DiagramElement getDiagramElement(String elementName) {
        try {
            DataElement element = (DataElement)this.diagram.findObject(elementName);
            while (!(element instanceof DiagramElement) && element != null) {
                if (element instanceof Option) {
                    element = (DataElement)((Option)element).getParent();
                    continue;
                }
                element = element.getOrigin();
            }
            if (element != null) {
                return (DiagramElement)element;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Icon getIcon(Object type) {
        return this.baseViewBuilder.getIcon(type);
    }
}

