/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.standard.state.State;
import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.state.StateUndoManager;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;
import ru.biosoft.util.BeanUtil;

public class StateChangeListener
implements PropertyChangeListener,
DataCollectionListener,
TransactionListener {
    protected State state;
    private StateUndoManager undoManager;
    protected boolean lock = false;
    protected static final Logger log = Logger.getLogger(StateChangeListener.class.getName());
    protected DataElement elementToRemove = null;

    public StateChangeListener(State state) {
        this.undoManager = state.getStateUndoManager();
        this.state = state;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (pce.getPropagationId() != pce.getSource() && pce.getPropagationId() instanceof Option && pce.getSource() instanceof Option) {
                Option parent = ((Option)pce.getSource()).getParent();
                if (parent == null) {
                    parent = (Option)pce.getPropagationId();
                }
                while (!(parent instanceof DiagramElement) && parent != null) {
                    parent = parent.getParent();
                }
                String propertyPath = BeanUtil.getPropertyPathFromRoot((Option)((Option)pce.getSource()), (Option)parent, (String)pce.getPropertyName());
                if (propertyPath != null) {
                    pce = new PropertyChangeEvent(parent, propertyPath, pce.getOldValue(), pce.getNewValue());
                }
            }
            if (pce.getSource() instanceof DataElement && !this.undoManager.isRedo() && !this.undoManager.isUndo()) {
                if (!pce.getPropertyName().equals("currentStateName")) {
                    this.undoManager.addEdit(new StatePropertyChangeUndo(pce));
                } else if (!((DataElement)pce.getSource()).getCompletePath().equals((Object)DataElementPath.create((String)this.state.getAttributes().getValueAsString("diagram")))) {
                    this.undoManager.addEdit(new StatePropertyChangeUndo(pce));
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Exception while property change in state '" + this.state.getName() + "'", t);
        }
        this.lock = false;
    }

    public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementAdded(DataCollectionEvent e) throws Exception {
        if (this.lock) {
            return;
        }
        this.lock = true;
        DataElement element = e.getDataElement();
        if (element != null) {
            DataCollectionAddUndo undo = new DataCollectionAddUndo(element, e.getOwner());
            this.undoManager.addEdit((UndoableEdit)undo);
            if (element instanceof Edge && ((DiagramElement)element).getRole() != null) {
                this.undoManager.addEdit(new StatePropertyChangeUndo(element, "role", null, ((DiagramElement)element).getRole()));
            }
        }
        this.lock = false;
    }

    public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        this.elementToRemove = e.getDataElement();
    }

    public void elementRemoved(DataCollectionEvent e) throws Exception {
        if (this.lock) {
            return;
        }
        this.lock = true;
        if (this.elementToRemove != null) {
            DataCollectionRemoveUndo undo = new DataCollectionRemoveUndo(this.elementToRemove, e.getOwner());
            this.undoManager.addEdit((UndoableEdit)undo);
        }
        this.lock = false;
    }

    public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        while (e.getPrimaryEvent() != null) {
            e = e.getPrimaryEvent();
        }
        if (e.getType() == 3) {
            this.elementWillRemove(e);
        }
    }

    public void elementChanged(DataCollectionEvent e) throws Exception {
        while (e.getPrimaryEvent() != null) {
            e = e.getPrimaryEvent();
        }
        if (e.getType() == 4) {
            this.elementAdded(e);
        }
        if (e.getType() == 6) {
            this.elementRemoved(e);
        }
    }

    protected boolean elementWasAdded(DataElement element) {
        this.lock = true;
        boolean result = false;
        List<UndoableEdit> edits = this.undoManager.getEditsFlat();
        for (int i = 0; i < edits.size(); ++i) {
            UndoableEdit ue = edits.get(i);
            if (ue instanceof DataCollectionAddUndo && ((DataCollectionAddUndo)ue).getDataElement() == element) {
                edits.remove(i);
                result = true;
                --i;
                continue;
            }
            if (!result || !(ue instanceof StatePropertyChangeUndo) || ((StatePropertyChangeUndo)ue).getSource() != element) continue;
            edits.remove(i);
            --i;
        }
        this.lock = false;
        return result;
    }

    public void startTransaction(TransactionEvent te) {
        this.state.startTransaction(te);
    }

    public boolean addEdit(UndoableEdit ue) {
        return true;
    }

    public void completeTransaction() {
        this.state.completeTransaction();
    }
}

