/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.standard.state.DiagramStateUtility;
import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.state.StateUndoManager;
import biouml.standard.type.Concept;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.undo.Transaction;
import com.developmentontheedge.beans.undo.TransactionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;

@PropertyName(value="state")
public class State
extends Concept {
    protected static final Logger log = Logger.getLogger(State.class.getName());
    protected static final String DIAGRAM_REF = "diagram";
    private String description;
    protected String version;
    protected StateUndoManager stateUndoManager;

    public State(Diagram diagram, String name) {
        this(null, diagram, name);
    }

    public State(DataCollection<?> parent, Diagram diagram, String name) {
        super(parent, name);
        try {
            this.getAttributes().add(new DynamicProperty(DIAGRAM_REF, DataElementPath.class, (Object)DataElementPath.create((DataElement)diagram)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public State(DataCollection<?> parent, Diagram diagram, String name, List<UndoableEdit> edits) throws Exception {
        this(parent, diagram, name);
        diagram.addState(this);
        diagram.setStateEditingMode(this);
        boolean isEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(true);
        boolean isModelNotify = true;
        EModel emodel = null;
        if (diagram.getRole() instanceof EModel) {
            emodel = diagram.getRole(EModel.class);
            isModelNotify = emodel.isNotificationEnabled();
            emodel.setNotificationEnabled(true);
        }
        this.cloneEdits((Diagram)parent, edits);
        diagram.setNotificationEnabled(isEnabled);
        if (emodel != null) {
            emodel.setNotificationEnabled(isModelNotify);
        }
        diagram.restore();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nonnull
    public StateUndoManager getStateUndoManager() {
        if (this.stateUndoManager == null) {
            this.stateUndoManager = new StateUndoManager();
        }
        return this.stateUndoManager;
    }

    public State clone(Diagram diagram, String name) throws Exception {
        return this.clone(null, diagram, name);
    }

    public State clone(DataCollection<?> parent, Diagram diagram, String name) throws Exception {
        State state = new State(parent, diagram, name);
        state.setComment(this.getComment());
        state.setDescription(this.getDescription());
        state.setDate(this.getDate());
        state.setDatabaseReferences(this.getDatabaseReferences());
        state.setLiteratureReferences(this.getLiteratureReferences());
        state.setSynonyms(this.getSynonyms());
        state.setTitle(this.getTitle());
        state.setType(this.getType());
        state.setVersion(this.getVersion());
        if (diagram != null) {
            diagram.addState(state);
            diagram.setStateEditingMode(state);
            List edits = this.getStateUndoManager().getEdits();
            boolean isNotificationEnabled = diagram.isNotificationEnabled();
            diagram.setNotificationEnabled(true);
            boolean isPropagationEnabled = diagram.isPropagationEnabled();
            diagram.setPropagationEnabled(true);
            boolean isModelNotify = true;
            EModel emodel = null;
            Role role = diagram.getRole();
            if (role instanceof EModel) {
                emodel = (EModel)role;
                isModelNotify = emodel.isNotificationEnabled();
                emodel.setNotificationEnabled(true);
            }
            try {
                state.cloneEdits(diagram, edits);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not clone edits of the state '" + this.getName() + "'");
            }
            diagram.setNotificationEnabled(isNotificationEnabled);
            diagram.setPropagationEnabled(isPropagationEnabled);
            if (emodel != null) {
                emodel.setNotificationEnabled(isModelNotify);
            }
            diagram.restore();
        }
        return state;
    }

    protected void cloneEdits(Diagram diagram, List<UndoableEdit> edits) throws Exception {
        for (UndoableEdit edit : edits) {
            if (edit instanceof Transaction) {
                this.startTransaction(new TransactionEvent((Object)this, edit.getPresentationName()));
                this.setTransactionComment(((Transaction)edit).getComment());
                this.cloneEdits(diagram, ((Transaction)edit).getEdits());
                this.completeTransaction();
                continue;
            }
            if (edit instanceof DataCollectionRemoveUndo) {
                DiagramStateUtility.redoRemoveEdit(diagram, (DataCollectionRemoveUndo)edit);
                continue;
            }
            if (edit instanceof DataCollectionAddUndo) {
                DiagramStateUtility.redoAddEdit(diagram, (DataCollectionAddUndo)edit);
                continue;
            }
            if (!(edit instanceof StatePropertyChangeUndo)) continue;
            DiagramStateUtility.redoPropertyChangeEdit(diagram, (StatePropertyChangeUndo)edit);
        }
    }

    public void startTransaction(TransactionEvent te) {
        this.getStateUndoManager().startTransaction(te);
    }

    public void completeTransaction() {
        this.getStateUndoManager().completeTransaction();
    }

    public void setTransactionComment(String comment) {
        this.getStateUndoManager().setTransactionComment(comment);
    }
}

