/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.state.UndoableEditFormatter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;

public class ModelEditFormatter
implements UndoableEditFormatter {
    private static final Set<String> significantPropertiesNames = new HashSet<String>();

    @Override
    public String getPresentationName(UndoableEdit edit) {
        StatePropertyChangeUndo pcu;
        String name;
        DataElementPath propertyPath;
        String propertyName;
        DataElement de;
        DiagramElement node = null;
        String suffix = "";
        if (edit instanceof DataCollectionAddUndo) {
            de = ((DataCollectionAddUndo)edit).getDataElement();
            if (de instanceof Node) {
                node = (Node)de;
            }
            suffix = "added";
        } else if (edit instanceof DataCollectionRemoveUndo) {
            de = ((DataCollectionRemoveUndo)edit).getDataElement();
            if (de instanceof Node) {
                node = (Node)de;
            }
            suffix = "removed";
        }
        if (node != null) {
            String name2 = node.getTitle() != null ? (!node.getTitle().isEmpty() ? node.getTitle() : node.getName()) : node.getName();
            return name2 + ": " + suffix;
        }
        if (edit instanceof StatePropertyChangeUndo && significantPropertiesNames.contains(propertyName = (propertyPath = DataElementPath.create((String)(name = (pcu = (StatePropertyChangeUndo)edit).getPropertyName()))).getName())) {
            String owner = propertyPath.getParentPath().getName().isEmpty() || propertyPath.getParentPath().getName().equals("role") ? (pcu.getSource() instanceof DataElement ? ((DataElement)pcu.getSource()).getName() : "") : propertyPath.getParentPath().getName();
            Object newValue = pcu.getNewValue();
            Object oldValue = pcu.getOldValue();
            if (newValue != null || oldValue != null) {
                Class<?> type = null;
                type = newValue != null ? newValue.getClass() : oldValue.getClass();
                if (type.isPrimitive() || type.equals(String.class) || type.equals(Integer.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class)) {
                    return this.getPresentationString(owner, propertyPath.getName(), newValue, oldValue);
                }
                owner = owner.isEmpty() ? propertyName : owner + " (" + propertyName + ")";
                return owner.isEmpty() + " changed";
            }
        }
        return null;
    }

    @Override
    public boolean isSignificant(UndoableEdit edit) {
        if (edit instanceof DataCollectionAddUndo) {
            DataElement de = ((DataCollectionAddUndo)edit).getDataElement();
            return de instanceof Node;
        }
        if (edit instanceof DataCollectionRemoveUndo) {
            DataElement de = ((DataCollectionRemoveUndo)edit).getDataElement();
            return de instanceof Node;
        }
        if (edit instanceof StatePropertyChangeUndo) {
            StatePropertyChangeUndo pcu = (StatePropertyChangeUndo)edit;
            return significantPropertiesNames.contains(DataElementPath.create((String)pcu.getPropertyName()).getName());
        }
        return false;
    }

    private String getPresentationString(String ownerName, String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("initialValue")) {
            return ownerName + ": " + oldValue + " -> " + newValue;
        }
        if (propertyName.equals("isConstant")) {
            return ownerName + (Boolean.parseBoolean(newValue + "") ? " is constant" : "is not constant");
        }
        if (propertyName.equals("boundaryCondition")) {
            return ownerName + (Boolean.parseBoolean(newValue + "") ? " uses boundary condition" : "no boundary condition");
        }
        return ownerName + " (" + propertyName + "): " + oldValue + " -> " + newValue;
    }

    static {
        significantPropertiesNames.add("initialValue");
        significantPropertiesNames.add("isConstant");
        significantPropertiesNames.add("boundaryCondition");
        significantPropertiesNames.add("formula");
    }
}

