/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.standard.diagram.CreatorElementWithName;
import biouml.standard.state.State;
import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.CompositeProperty;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.undo.Transaction;
import java.awt.Point;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graph.Layouter;
import ru.biosoft.util.BeanUtil;
import ru.biosoft.util.TextUtil;

public class DiagramStateUtility {
    @Nonnull
    public static State createState(Diagram original, Diagram changed, String name) throws Exception {
        Diagram base = original.clone(original.getOrigin(), original.getName());
        State state = new State(null, base, name);
        base.addState(state);
        base.setStateEditingMode(state);
        DiagramStateUtility.copyChanges(base, changed);
        base.restore();
        base.removeState(state);
        return state;
    }

    public static void copyChanges(Diagram base, Diagram changed) throws Exception {
        boolean notificationEnabled = base.isNotificationEnabled();
        base.setNotificationEnabled(true);
        Layouter bl = base.getPathLayouter();
        Layouter cl = changed.getPathLayouter();
        if (!DiagramStateUtility.sameNull(cl, bl) || cl != null && !DiagramStateUtility.sameClass(cl, bl)) {
            base.setPathLayouter(changed.getPathLayouter());
        }
        Layouter bll = base.getLabelLayouter();
        Layouter cll = changed.getLabelLayouter();
        if (!DiagramStateUtility.sameNull(cll, bll) || cll != null && !DiagramStateUtility.sameClass(cll, bll)) {
            base.setLabelLayouter(changed.getLabelLayouter());
        }
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("role");
        exclude.add("kernel");
        exclude.add("attributes");
        exclude.add("origin");
        exclude.add("diagramType");
        exclude.add("layouter");
        exclude.add("currentStateName");
        DiagramStateUtility.copyChanges(base, changed, exclude);
        base.setNotificationEnabled(notificationEnabled);
    }

    private static void copyChanges(Compartment base, Compartment changed, Set<String> exclude) throws Exception {
        try {
            DiagramElement de;
            for (String name : base.getNameList()) {
                Edge edge;
                DiagramElement debaseElement = base.get(name);
                if (!(debaseElement instanceof Edge) || (de = changed.get((edge = (Edge)debaseElement).getName())) != null && DiagramStateUtility.sameClass((Object)de, (Object)edge) && DiagramStateUtility.sameKernels(edge.getKernel(), de.getKernel())) continue;
                base.remove(edge.getName());
            }
            for (Node node : base.getNodes()) {
                de = changed.get(node.getName());
                if (de != null && DiagramStateUtility.sameClass((Object)de, (Object)node) && DiagramStateUtility.sameKernels(node.getKernel(), de.getKernel())) continue;
                base.remove(node.getName());
            }
            for (Node node : changed.getNodes()) {
                DiagramElement debase = base.get(node.getName());
                if (!(debase == null || DiagramStateUtility.sameClass((Object)node, (Object)debase) && DiagramStateUtility.sameKernels(debase.getKernel(), node.getKernel()))) {
                    debase = null;
                }
                if (node instanceof Compartment) {
                    Compartment node2 = (Compartment)node;
                    if (debase == null) {
                        base.setNotificationEnabled(false);
                        Compartment n = node2.clone(base, node2.getName());
                        base.setNotificationEnabled(true);
                        base.put(n);
                        continue;
                    }
                    DiagramStateUtility.copyChanges((Compartment)debase, node2, null);
                    continue;
                }
                if (debase == null) {
                    base.setNotificationEnabled(false);
                    Node newElement = node.clone(base, node.getName());
                    base.setNotificationEnabled(true);
                    base.put(newElement);
                    continue;
                }
                DiagramStateUtility.copyChanges(debase, node, null);
            }
            for (Edge de2 : changed.stream(Edge.class)) {
                DiagramElement debase = base.get(de2.getName());
                if (!(debase == null || DiagramStateUtility.sameClass((Object)de2, (Object)debase) && DiagramStateUtility.sameKernels(debase.getKernel(), de2.getKernel()))) {
                    debase = null;
                }
                if (debase == null) {
                    base.setNotificationEnabled(false);
                    Edge edge = de2.clone(base, de2.getName());
                    base.setNotificationEnabled(true);
                    base.put(edge);
                    continue;
                }
                DiagramStateUtility.copyChanges(debase, de2, null);
            }
            DiagramStateUtility.copyChanges((DiagramElement)base, (DiagramElement)changed, exclude);
        }
        catch (Exception exc) {
            throw new Exception("Comparing compartments error", exc);
        }
    }

    private static void copyChanges(DiagramElement base, DiagramElement changed, Set<String> exclude) {
        if (exclude == null) {
            exclude = new HashSet<String>();
        }
        exclude.add("role");
        exclude.add("kernel");
        exclude.add("attributes");
        exclude.add("origin");
        exclude.add("note_background");
        exclude.add("image");
        DiagramStateUtility.copyChanges((CompositeProperty)ComponentFactory.getModel((Object)((Object)base), (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true), (CompositeProperty)ComponentFactory.getModel((Object)((Object)changed), (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true), exclude);
        DiagramStateUtility.copyChanges(base.getAttributes(), changed.getAttributes());
        DiagramStateUtility.copyRoleChanges(base, changed);
    }

    private static void copyRoleChanges(DiagramElement base, DiagramElement changed) {
        Role role = base.getRole();
        Role chRole = changed.getRole();
        if (chRole == null && role != null) {
            base.setRole(null);
            return;
        }
        if (chRole == null && role == null) {
            return;
        }
        if (!DiagramStateUtility.sameClass(role, chRole)) {
            base.setRole(chRole.clone(base));
        }
        ComponentModel baseRole = ComponentFactory.getModel((Object)base.getRole(), (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true);
        ComponentModel changedRole = ComponentFactory.getModel((Object)chRole, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true);
        HashSet<String> exclude2 = new HashSet<String>();
        if (chRole instanceof EModel) {
            DataCollection<Variable> chvars = ((EModel)chRole).getVariables();
            DataCollection<Variable> vars = ((EModel)role).getVariables();
            DiagramStateUtility.copyVariablesChanges(vars, chvars);
            exclude2.add("vars");
        }
        DiagramStateUtility.copyChanges((CompositeProperty)baseRole, (CompositeProperty)changedRole, exclude2);
    }

    private static void copyChanges(CompositeProperty base, CompositeProperty changed, Set<String> excludeNames) {
        for (int i = 0; i < changed.getPropertyCount(); ++i) {
            Property baseProp;
            Property property = changed.getPropertyAt(i);
            if (excludeNames.contains(property.getName()) || (baseProp = base.getPropertyAt(i)) == null) continue;
            try {
                Object value = property.getValue();
                Object baseValue = baseProp.getValue();
                if (value == null && baseValue == null) continue;
                if (value == null) {
                    baseProp.setValue(null);
                    continue;
                }
                if (baseValue != null && baseValue.equals(value)) continue;
                if (property instanceof CompositeProperty) {
                    if (value instanceof Cloneable) {
                        baseProp.setValue(value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]));
                        continue;
                    }
                    Object newValue = TextUtil.fromString(value.getClass(), (String)TextUtil.toString((Object)value));
                    if (newValue != null) {
                        baseProp.setValue(newValue);
                        continue;
                    }
                    DiagramStateUtility.copyChanges((CompositeProperty)property, (CompositeProperty)baseProp, excludeNames);
                    continue;
                }
                if (property instanceof ArrayProperty) continue;
                baseProp.setValue(value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void copyChanges(DynamicPropertySet base, DynamicPropertySet changed) {
        if (changed != null) {
            Iterator iter = changed.nameIterator();
            while (iter.hasNext()) {
                DynamicProperty oldProp = changed.getProperty((String)iter.next());
                DynamicProperty prop = base.getProperty(oldProp.getName());
                if (prop != null) {
                    if (oldProp.getValue().equals(prop.getValue())) continue;
                    prop.setValue(oldProp.getValue());
                    continue;
                }
                try {
                    prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                    base.add(prop);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void copyVariablesChanges(DataCollection<?> base, DataCollection<?> changed) {
        List names = changed.getNameList();
        for (String name : names) {
            DataElement de = null;
            DataElement chde = null;
            try {
                de = base.get(name);
                chde = changed.get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (de == null) continue;
            DiagramStateUtility.copyChanges((CompositeProperty)ComponentFactory.getModel((Object)de, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true), (CompositeProperty)ComponentFactory.getModel((Object)chde, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true), new HashSet<String>());
        }
        names = base.getNameList();
        Iterator iter = names.iterator();
        ArrayList<String> toRemove = new ArrayList<String>();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DataElement de = null;
            try {
                de = changed.get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (de != null) continue;
            toRemove.add(name);
        }
        for (String name : toRemove) {
            try {
                base.remove(name);
            }
            catch (Exception exception) {}
        }
    }

    private static boolean sameNull(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null;
    }

    private static boolean sameClass(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.getClass().equals(o2.getClass());
    }

    private static boolean sameModels(CompositeProperty base, CompositeProperty changed, Set<String> excludeNames) {
        if (base == null) {
            return changed == null;
        }
        if (changed == null) {
            return false;
        }
        for (int i = 0; i < changed.getPropertyCount(); ++i) {
            Property property = changed.getPropertyAt(i);
            if (excludeNames.contains(property.getName())) continue;
            Property baseProp = base.getPropertyAt(i);
            if (baseProp != null) {
                if (baseProp.getValue() == null && property.getValue() == null) continue;
                if (!DiagramStateUtility.sameClass(baseProp.getValue(), property.getValue())) {
                    return false;
                }
                if (!(property instanceof CompositeProperty ? !DiagramStateUtility.sameModels((CompositeProperty)property, (CompositeProperty)baseProp, excludeNames) : !(property instanceof ArrayProperty) && property.getValue() != null && !property.getValue().equals(baseProp.getValue()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean sameKernels(Base kernel, Base changedKernel) {
        if (!DiagramStateUtility.sameNull(kernel, changedKernel) || !DiagramStateUtility.sameClass(kernel, changedKernel)) {
            return false;
        }
        if (kernel == null) {
            return true;
        }
        if (kernel.getOrigin() != null && changedKernel.getOrigin() != null && !(kernel instanceof Stub) && !(kernel instanceof SpecieReference)) {
            return kernel == changedKernel;
        }
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("role");
        exclude.add("kernel");
        exclude.add("attributes");
        exclude.add("origin");
        exclude.add("note_background");
        exclude.add("image");
        DiagramStateUtility.copyChanges((CompositeProperty)ComponentFactory.getModel((Object)kernel), (CompositeProperty)ComponentFactory.getModel((Object)changedKernel), exclude);
        DiagramStateUtility.copyChanges((CompositeProperty)ComponentFactory.getModel((Object)kernel.getAttributes()), (CompositeProperty)ComponentFactory.getModel((Object)changedKernel.getAttributes()), new HashSet<String>());
        return true;
    }

    public static void applyState(Diagram diagram, State state) throws Exception {
        DiagramStateUtility.applyState(diagram, state, state.getName());
    }

    public static void applyState(Diagram diagram, State state, String newName) throws Exception {
        State oldState = diagram.getState(newName);
        if (oldState != null) {
            diagram.removeState(oldState);
        }
        State newState = state.clone(diagram, newName);
        newState.setTitle(newName);
        diagram.addState(newState);
        diagram.setCurrentStateName(newState.getName());
    }

    public static void applyStateEdits(Diagram diagram, State state) throws Exception {
        state.cloneEdits(diagram, state.getStateUndoManager().getEdits());
    }

    public static Diagram getDiagramCloneWithUndo(Diagram diagram, List<UndoableEdit> edits) throws Exception {
        Diagram result = diagram.clone(diagram.getOrigin(), diagram.getName());
        result.setNotificationEnabled(false);
        DiagramStateUtility.undoEdits(result, edits);
        result.setNotificationEnabled(true);
        return result;
    }

    public static Diagram getDiagramCloneWithRedo(Diagram diagram, List<UndoableEdit> edits) throws Exception {
        Diagram result = diagram.clone(diagram.getOrigin(), diagram.getName());
        result.setNotificationEnabled(false);
        DiagramStateUtility.redoEdits(result, edits);
        result.setNotificationEnabled(true);
        return result;
    }

    public static void undoEdits(Diagram diagram, List<UndoableEdit> edits) throws Exception {
        for (int i = edits.size() - 1; i >= 0; --i) {
            UndoableEdit edit = edits.get(i);
            if (edit instanceof Transaction) {
                DiagramStateUtility.undoEdits(diagram, ((Transaction)edit).getEdits());
                continue;
            }
            if (edit instanceof DataCollectionRemoveUndo) {
                DiagramStateUtility.undoRemoveEdit(diagram, (DataCollectionRemoveUndo)edit);
                continue;
            }
            if (edit instanceof DataCollectionAddUndo) {
                DiagramStateUtility.undoAddEdit(diagram, (DataCollectionAddUndo)edit);
                continue;
            }
            if (!(edit instanceof StatePropertyChangeUndo)) continue;
            DiagramStateUtility.undoPropertyChangeEdit(diagram, (StatePropertyChangeUndo)edit);
        }
    }

    public static void redoEdits(Diagram diagram, List<UndoableEdit> edits) throws Exception {
        for (UndoableEdit edit : edits) {
            if (edit instanceof Transaction) {
                DiagramStateUtility.redoEdits(diagram, ((Transaction)edit).getEdits());
                continue;
            }
            if (edit instanceof DataCollectionRemoveUndo) {
                DiagramStateUtility.redoRemoveEdit(diagram, (DataCollectionRemoveUndo)edit);
                continue;
            }
            if (edit instanceof DataCollectionAddUndo) {
                DiagramStateUtility.redoAddEdit(diagram, (DataCollectionAddUndo)edit);
                continue;
            }
            if (!(edit instanceof StatePropertyChangeUndo)) continue;
            DiagramStateUtility.redoPropertyChangeEdit(diagram, (StatePropertyChangeUndo)edit);
        }
    }

    protected static void undoAddEdit(Diagram diagram, DataCollectionAddUndo edit) throws Exception {
        DiagramStateUtility.removeElement(diagram, edit.getDataElement());
    }

    protected static void redoAddEdit(Diagram diagram, DataCollectionAddUndo edit) throws Exception {
        DiagramStateUtility.addElement(diagram, edit.getDataElement());
    }

    protected static void undoRemoveEdit(Diagram diagram, DataCollectionRemoveUndo edit) throws Exception {
        DiagramStateUtility.addElement(diagram, edit.getDataElement());
    }

    protected static void redoRemoveEdit(Diagram diagram, DataCollectionRemoveUndo edit) throws Exception {
        DiagramStateUtility.removeElement(diagram, edit.getDataElement());
    }

    protected static void undoPropertyChangeEdit(Diagram diagram, StatePropertyChangeUndo edit) throws Exception {
        DiagramStateUtility.changeProperty(diagram, edit.getSource(), edit.getPropertyName(), edit.getOldValue());
    }

    protected static void redoPropertyChangeEdit(Diagram diagram, StatePropertyChangeUndo edit) throws Exception {
        DiagramStateUtility.changeProperty(diagram, edit.getSource(), edit.getPropertyName(), edit.getNewValue());
    }

    private static void changeProperty(Diagram diagram, Object oldSource, String propertyName, Object newValue) throws Exception {
        if (oldSource instanceof DataElement) {
            Object source;
            DataElement de = (DataElement)oldSource;
            String elementID = de.getName();
            if (de instanceof DiagramElement) {
                String string = elementID = de instanceof Diagram ? "" : ((DiagramElement)de).getCompleteNameInDiagram();
            }
            if ((source = diagram.getDiagramElement(elementID)) == null) {
                source = diagram.findObject(elementID);
            }
            if (source instanceof DiagramElement && de instanceof Base) {
                source = ((DiagramElement)((Object)source)).getKernel();
            }
            Role role = diagram.getRole();
            if (source == null && role instanceof EModel) {
                EModel model = (EModel)role;
                source = model.getParameters().get(elementID);
            }
            if (source != null) {
                if (newValue instanceof Role) {
                    newValue = ((Role)newValue).clone((DiagramElement)((Object)source));
                }
                try {
                    BeanUtil.setBeanPropertyValue((Object)source, (String)propertyName, (Object)newValue);
                }
                catch (IntrospectionException e) {
                    throw new InternalException((Throwable)e);
                }
            }
        }
    }

    private static void removeElement(Diagram diagram, DataElement oldElement) throws Exception {
        DiagramElement de;
        DiagramElement source;
        if (oldElement instanceof DiagramElement && (source = diagram.getDiagramElement((de = (DiagramElement)oldElement).getCompleteNameInDiagram())) != null) {
            source.getOrigin().remove(source.getName());
        }
    }

    private static void addElement(Diagram diagram, DataElement oldElement) throws Exception {
        DiagramElement de;
        if (oldElement instanceof DiagramElement && (de = (DiagramElement)oldElement).getParent() instanceof Compartment) {
            Compartment oldComp = de.getCompartment();
            Compartment newComp = (Compartment)diagram.findDiagramElement(oldComp.getCompleteNameInDiagram());
            if (newComp == null) {
                newComp = diagram;
            }
            SemanticController sc = diagram.getType().getSemanticController();
            Point location = de instanceof Node ? ((Node)de).getLocation() : null;
            Object properties = de.getKernel() instanceof Reaction ? de.getKernel() : de.getRole();
            DiagramElement newElement = null;
            if (sc instanceof CreatorElementWithName) {
                newElement = ((CreatorElementWithName)sc).createInstance(newComp, de.getKernel().getClass(), de.getName(), location, properties).getElement();
            }
            if (newElement == null) {
                newElement = de.clone(newComp, de.getName());
            }
            if (newElement != null && !newComp.contains((DataElement)newElement) && sc.canAccept(newComp, newElement)) {
                newComp.put(newElement);
            }
        }
    }

    public static Diagram getNativeDiagram(State state) {
        DynamicProperty dp = state.getAttributes().getProperty("diagram");
        if (dp == null || dp.getType() != DataElementPath.class) {
            return null;
        }
        DataElement de = ((DataElementPath)dp.getValue()).optDataElement();
        return de instanceof Diagram ? (Diagram)de : null;
    }
}

