/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.model.util.DiagramXmlReader;
import biouml.model.util.DiagramXmlWriter;
import biouml.standard.state.DiagramStateUtility;
import biouml.standard.state.State;
import biouml.standard.state.StateXmlSerializer;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.history.DiffManager;
import ru.biosoft.access.history.HistoryElement;
import ru.biosoft.exception.InternalException;

public class DiagramDiffManager
implements DiffManager {
    public int getPriority(Class elementType) {
        if (Diagram.class.isAssignableFrom(elementType)) {
            return 10;
        }
        return 0;
    }

    public void fillDifference(HistoryElement historyElement, DataElement oldElement, DataElement newElement) throws Exception {
        State state = DiagramStateUtility.createState((Diagram)newElement, (Diagram)oldElement, historyElement.getName());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Diagram diagram = DiagramStateUtility.getNativeDiagram(state);
        if (diagram == null) {
            throw new InternalException("Diagram for state is missing");
        }
        DiagramXmlWriter diagramWriter = new DiagramXmlWriter(doc, diagram);
        Element stateElement = StateXmlSerializer.getStateXmlElement(state, doc, diagramWriter);
        doc.appendChild(stateElement);
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        historyElement.setData(stringWriter.toString());
    }

    public Object parseDifference(DataElement de, HistoryElement historyElement) throws Exception {
        ByteArrayInputStream bs = new ByteArrayInputStream(historyElement.getData().getBytes());
        DiagramXmlReader reader = new DiagramXmlReader(de.getName(), bs, null);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(bs);
        Element stateElement = document.getDocumentElement();
        reader.setDiagram((Diagram)de);
        State state = StateXmlSerializer.readXmlElement(stateElement, (Diagram)de, reader);
        return state;
    }

    public DataElement applyDifference(DataElement de, HistoryElement[] historyElements) throws Exception {
        Diagram result = ((Diagram)de).clone(de.getOrigin(), de.getName());
        for (int i = 0; i < historyElements.length - 1; ++i) {
            HistoryElement he = historyElements[i];
            DiagramStateUtility.redoEdits(result, ((State)he.getDataObj((DataElement)result, (DiffManager)this)).getStateUndoManager().getEdits());
        }
        return result;
    }

    public DataElement getDifferenceElement(DataElement first, DataElement second) throws Exception {
        State state = DiagramStateUtility.createState((Diagram)first, (Diagram)second, "");
        Diagram result = ((Diagram)first).clone(first.getOrigin(), first.getName());
        DiagramStateUtility.applyState(result, state, state.getName());
        return result;
    }
}

