/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.state;

import biouml.model.Diagram;
import biouml.standard.state.State;
import biouml.standard.state.StateTabListener;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.MutableDataElementSupport;

public class ChangesTab
extends JPanel {
    protected Diagram diagram;
    protected TabularPropertyInspector changesTable;
    protected JComboBox<String> statesComboBox;
    protected StateTabListener tabListener;
    protected boolean selectionEnabled = false;

    public ChangesTab(StateTabListener listener) {
        this.tabListener = listener;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        JLabel label1 = new JLabel("States:");
        this.add((Component)label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.statesComboBox = new JComboBox();
        this.add(this.statesComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.changesTable = new TabularPropertyInspector();
        this.add((Component)this.changesTable, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.statesComboBox.addActionListener(e -> {
            if (this.selectionEnabled) {
                String stateName = (String)this.statesComboBox.getSelectedItem();
                State selectedState = this.diagram.getState(stateName);
                this.tabListener.setCurrentState(selectedState);
            }
        });
    }

    protected void changeState(State state) {
        if (state != null) {
            List elements = state.getStateUndoManager().getEdits();
            this.changesTable.explore((Object[])elements.toArray(new UndoableEdit[elements.size()]));
            if (!((String)this.statesComboBox.getSelectedItem()).equals(state.getName())) {
                this.statesComboBox.setSelectedItem(state.getName());
            }
        } else {
            String selectedItem = (String)this.statesComboBox.getSelectedItem();
            if (selectedItem != null) {
                this.statesComboBox.setSelectedItem(selectedItem);
            }
        }
    }

    public void refresh(Diagram diagram) {
        this.diagram = diagram;
        this.selectionEnabled = false;
        this.statesComboBox.removeAllItems();
        this.changesTable.explore(new Object[0]);
        diagram.states().map(MutableDataElementSupport::getName).forEach(this.statesComboBox::addItem);
        this.selectionEnabled = true;
    }

    public TabularPropertyInspector getChangesTable() {
        return this.changesTable;
    }
}

