/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot.web;

import biouml.plugins.simulation.plot.TableSimulationResultsWrapper;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import com.eclipsesource.json.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.json.JSONArray;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.table.access.TableResolver;

public class SeriesTableResolver
extends TableResolver {
    private String what;
    private Map<String, List<String>> resultVariables;
    private double[] timeFilter;

    public SeriesTableResolver(BiosoftWebRequest arguments) {
        String columns = arguments.get("names");
        String times = arguments.get("times");
        this.what = "series";
        if (columns != null && times != null) {
            try {
                JSONArray timesArr = new JSONArray(times);
                this.timeFilter = StreamEx.of((Spliterator)timesArr.spliterator()).mapToDouble(val -> Double.parseDouble(val.toString())).toArray();
                JSONArray columnsArr = new JSONArray(columns);
                this.resultVariables = StreamEx.of((Spliterator)columnsArr.spliterator()).groupingBy(col -> ((JSONArray)col).getString(0), Collectors.mapping(col -> ((JSONArray)col).getString(1), Collectors.toList()));
                this.what = "data";
            }
            catch (ParseException | UnsupportedOperationException throwable) {
                // empty catch block
            }
        }
    }

    public String getRowId(DataElement de, String elementName) {
        return elementName;
    }

    public DataCollection<?> getTable(DataElement de) throws Exception {
        Plot plot = (Plot)de.cast(Plot.class);
        if (this.what.equals("series")) {
            VectorDataCollection vdc = new VectorDataCollection("Series", Series.class, null);
            List<Series> series = plot.getSeries();
            int i = 1;
            for (Series s : series) {
                s.setName("series_" + i);
                ++i;
                vdc.put((DataElement)s);
            }
            return vdc;
        }
        return new TableSimulationResultsWrapper(this.resultVariables, this.timeFilter);
    }
}

