/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot.web;

import biouml.model.dynamics.plot.PlotsInfo;
import biouml.plugins.simulation.plot.PlotEditorPane;
import biouml.plugins.simulation.plot.PlotEx;
import biouml.plugins.simulation.plot.PlotPane;
import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.Pen;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.server.servlets.webservices.JSONResponse;
import ru.biosoft.server.servlets.webservices.WebException;
import ru.biosoft.server.servlets.webservices.WebSession;
import ru.biosoft.server.servlets.webservices.providers.WebBeanProvider;
import ru.biosoft.server.servlets.webservices.providers.WebJSONProviderSupport;
import ru.biosoft.table.TableColumn;
import ru.biosoft.table.TableDataCollection;

public class PlotProvider
extends WebJSONProviderSupport {
    private static BufferedImage drawChart(Plot plot) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"Axis (X)", (String)"Axis (Y)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getXYPlot().setBackgroundPaint((Paint)Color.white);
        PlotPane.redrawChart((Plot)plot, (JFreeChart)chart);
        return chart.createBufferedImage(550, 350);
    }

    public void process(BiosoftWebRequest arguments, JSONResponse response) throws Exception {
        DataElementPath dePath = arguments.getDataElementPath();
        String action = arguments.getAction();
        if ("variables".equals(action)) {
            DataElement dc = dePath.optDataElement();
            if (dc != null) {
                JSONArray xVariable = new JSONArray();
                JSONArray yVariable = new JSONArray();
                if (dc instanceof SimulationResult) {
                    String path = arguments.getString("path");
                    for (String s2 : PlotEditorPane.getVariablesForPath((String)path, (SimulationResult)((SimulationResult)dc))) {
                        xVariable.put((Object)s2);
                        yVariable.put((Object)s2);
                    }
                } else if (dc instanceof TableDataCollection) {
                    boolean first = true;
                    for (TableColumn column : ((TableDataCollection)dc).getColumnModel()) {
                        (first ? xVariable : yVariable).put((Object)column.getName());
                        first = false;
                    }
                } else {
                    throw new IllegalArgumentException("Incorrect data element " + dePath.toString());
                }
                JSONObject result = new JSONObject();
                result.put("x", (Object)xVariable);
                result.put("y", (Object)yVariable);
                response.sendJSON((Object)result);
                return;
            }
            throw new IllegalArgumentException("Incorrect data element " + dePath.toString());
        }
        if ("paths".equals(action)) {
            DataElement dc = dePath.optDataElement();
            if (dc != null) {
                if (dc instanceof SimulationResult) {
                    Set<String> paths = ((SimulationResult)dc).getPaths();
                    response.sendStringArray(paths.toArray(new String[paths.size()]));
                    return;
                }
                if (dc instanceof TableDataCollection) {
                    response.sendString("");
                    return;
                }
                throw new IllegalArgumentException("Incorrect data element " + dePath.toString());
            }
            throw new IllegalArgumentException("Incorrect data element " + dePath.toString());
        }
        if ("savenew".equals(action)) {
            Plot plot = new Plot(null, dePath.getName());
            PlotEx.savePlot((Plot)plot, (DataElementPath)dePath);
            response.sendString("");
            return;
        }
        Object de = WebBeanProvider.getBean((String)dePath.toString());
        if (!(de instanceof Plot)) {
            throw new IllegalArgumentException("Object is not a plot: " + dePath);
        }
        Plot plot = (Plot)de;
        if ("add".equals(action)) {
            String source = arguments.get("source");
            String xVar = arguments.get("x");
            String yVar = arguments.get("y");
            String xPath = arguments.getOrDefault("xPath", "");
            String yPath = arguments.getOrDefault("yPath", "");
            if (source != null && xVar != null && yVar != null) {
                DataElement sourceDe = DataElementPath.create((String)source).optDataElement();
                Series.SourceNature nature = Series.SourceNature.EXPERIMENTAL_DATA;
                if (sourceDe instanceof SimulationResult) {
                    nature = Series.SourceNature.SIMULATION_RESULT;
                }
                Series series = Plot.getDefaultSeries(xPath, xVar, yPath, yVar, source, nature);
                Series existing = StreamEx.of(plot.getSeries()).findAny(s -> s.equals((Object)series)).orElse(null);
                if (existing != null) {
                    response.error("Series " + yVar + " for " + sourceDe.getName() + " already exist.");
                    return;
                }
                String legend = yVar;
                if (StreamEx.of(plot.getSeries()).anyMatch(s -> s.getLegend().equals(yVar))) {
                    legend = legend + " (" + sourceDe.getName() + ")";
                }
                series.setLegend(legend);
                Color seriesColor = PlotsInfo.POSSIBLE_COLORS[plot.getSeries().size() % PlotsInfo.POSSIBLE_COLORS.length];
                series.setSpec(new Pen(1.0f, seriesColor));
                plot.addSeries(series);
                response.sendString("");
            }
        } else if ("remove".equals(action)) {
            String[] snames = arguments.optStrings("series");
            if (snames != null) {
                List<Series> series = plot.getSeries();
                HashSet<String> names = new HashSet<String>(Arrays.asList(snames));
                series.removeIf(s -> names.contains(s.getName()));
                response.sendString("");
            }
        } else if ("save".equals(action)) {
            String path = arguments.getString("plot_path");
            PlotEx.savePlot((Plot)plot, (DataElementPath)DataElementPath.create((String)path));
            response.sendString("");
        } else if ("plot".equals(action)) {
            BufferedImage resultImage = PlotProvider.drawChart(plot);
            if (resultImage != null) {
                String imageName = dePath + "_img";
                WebSession.getCurrentSession().putImage(imageName, resultImage);
                JSONObject result = new JSONObject();
                result.put("image", (Object)imageName);
                result.put("needUpdate", plot.needUpdate());
                DataElementPath path = plot.getDefaultSource();
                if (path != null && !path.isEmpty()) {
                    result.put("path", (Object)path.toString());
                }
                response.sendJSON((Object)result);
            }
        } else if ("new".equals(action)) {
            plot.removeAllSeries();
            response.sendString("");
        } else if ("filters".equals(action)) {
            JSONObject result = new JSONObject();
            JSONArray seriesColumns = new JSONArray();
            JSONArray timeFilter = new JSONArray();
            List<Series> series = plot.getSeries();
            for (Series s3 : series) {
                if (s3.getSource() == null || !s3.getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT) || "time".equalsIgnoreCase(s3.getYVar())) continue;
                JSONArray col = new JSONArray();
                col.put((Object)s3.getSource());
                col.put((Object)(s3.getYPath().isEmpty() ? s3.getYVar() : s3.getYPath() + "/" + s3.getYVar()));
                seriesColumns.put((Object)col);
                if (!s3.getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT) || timeFilter.length() != 0) continue;
                SimulationResult sResult = (SimulationResult)DataElementPath.create((String)s3.getSource()).getDataElement(SimulationResult.class);
                double[] times = sResult.getTimes();
                timeFilter.put(times[0]);
                timeFilter.put(times[times.length - 1]);
                timeFilter.put(times[1] - times[0]);
            }
            if (seriesColumns.length() > 0 && timeFilter.length() > 0) {
                result.put("seriesColumns", (Object)seriesColumns);
                result.put("timeFilter", (Object)timeFilter);
            }
            response.sendJSON((Object)result);
        } else {
            throw new WebException("EX_QUERY_PARAM_INVALID_VALUE", new Object[]{"action"});
        }
    }
}

