/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot.access;

import biouml.standard.diagram.Util;
import biouml.standard.simulation.ScriptDataGenerator;
import biouml.standard.simulation.plot.DataGeneratorSeries;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.support.TagCommandSupport;
import ru.biosoft.access.support.TagEntryTransformer;
import ru.biosoft.graphics.Pen;

class SeriesCommand
extends TagCommandSupport<Plot> {
    protected static final Logger log = Logger.getLogger(SeriesCommand.class.getName());
    protected static String endl = System.getProperty("line.separator");
    private static final String TOKEN = "_SPACE_";
    Plot pl = null;

    public SeriesCommand(TagEntryTransformer<Plot> transformer) {
        super("SE", transformer);
    }

    public String getTaggedValue() {
        Plot pl = (Plot)this.transformer.getProcessedObject();
        StringBuffer result = new StringBuffer();
        List<Series> series = pl.getSeries();
        int seriesNumber = series.size();
        for (int i = 0; i < seriesNumber; ++i) {
            Series s = series.get(i);
            String plotName = s.getPlotName();
            if (plotName == null) {
                plotName = pl.getName();
            }
            String spec = null;
            if (s.getSpec() != null) {
                spec = s.getSpec().toString();
            }
            result.append(this.getTag() + "    " + this.replaceSpaces(plotName) + " " + this.replaceSpaces(spec) + " " + this.replaceSpaces(s.getLegend()) + " ");
            if (s instanceof DataGeneratorSeries) {
                result.append(this.replaceSpaces(((DataGeneratorSeries)s).getXGenerator().toString()) + " " + this.replaceSpaces(((DataGeneratorSeries)s).getYGenerator().toString()));
            } else {
                String xVar = s.getXPath().isEmpty() ? s.getXVar() : s.getXPath() + "/" + s.getXVar();
                String yVar = s.getYPath().isEmpty() ? s.getYVar() : s.getYPath() + "/" + s.getYVar();
                result.append(this.replaceSpaces(xVar) + " " + this.replaceSpaces(yVar) + " " + this.replaceSpaces(s.getSource()) + " " + this.replaceSpaces(s.getSourceNature().toString()));
            }
            result.append(" " + s.getName() + endl);
        }
        return result.toString();
    }

    public void start(String string) {
        this.pl = (Plot)this.transformer.getProcessedObject();
        this.pl.removeAllSeries();
    }

    public void addValue(String string) {
        StringTokenizer strtok = new StringTokenizer(string, " ");
        if (strtok.countTokens() == 7 || strtok.countTokens() == 8) {
            Series s = new Series();
            s.setPlotName(this.replaceSpacesBack(strtok.nextToken()));
            s.setSpec(Pen.createInstance((String)this.replaceSpacesBack(strtok.nextToken())));
            s.setLegend(this.replaceSpacesBack(strtok.nextToken()));
            String xPath = this.replaceSpacesBack(strtok.nextToken());
            if (xPath.contains("/")) {
                String[] pathComponents = Util.getMainPathComponents(xPath);
                s.setXPath(pathComponents[0]);
                s.setXVar(pathComponents[1]);
            } else {
                s.setXVar(xPath);
            }
            String yPath = this.replaceSpacesBack(strtok.nextToken());
            if (yPath.contains("/")) {
                String[] pathComponents = Util.getMainPathComponents(yPath);
                s.setYPath(pathComponents[0]);
                s.setYVar(pathComponents[1]);
            } else {
                s.setYVar(yPath);
            }
            s.setSource(this.replaceSpacesBack(strtok.nextToken()));
            String r = this.replaceSpacesBack(strtok.nextToken());
            s.setSourceNature(Series.SourceNature.valueOf(r));
            try {
                String name = strtok.nextToken();
                s.setName(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pl.addSeries(s);
        } else if (strtok.countTokens() == 6) {
            DataGeneratorSeries s = new DataGeneratorSeries();
            s.setPlotName(this.replaceSpacesBack(strtok.nextToken()));
            s.setSpec(Pen.createInstance((String)this.replaceSpacesBack(strtok.nextToken())));
            s.setLegend(this.replaceSpacesBack(strtok.nextToken()));
            ScriptDataGenerator sdgX = new ScriptDataGenerator(this.replaceSpacesBack(strtok.nextToken()));
            ScriptDataGenerator sdgY = new ScriptDataGenerator(this.replaceSpacesBack(strtok.nextToken()));
            s.setXGenerator(sdgX);
            s.setYGenerator(sdgY);
            s.setName(this.replaceSpacesBack(strtok.nextToken()));
            this.pl.addSeries(s);
        } else {
            log.log(Level.SEVERE, "Could not parse the string: " + string);
            return;
        }
    }

    private String replaceSpaces(String str) {
        if (str == null) {
            return str;
        }
        String result = str.replaceAll(" ", TOKEN);
        if (result.equals("")) {
            result = TOKEN;
        }
        return result;
    }

    private String replaceSpacesBack(String str) {
        String result = str;
        if (result.equals(TOKEN)) {
            result = "";
        }
        result = result.replaceAll(TOKEN, " ");
        return result;
    }
}

