/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot.access;

import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.SqlTransformerSupport;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.graphics.Pen;

public class PlotSqlTransformer
extends SqlTransformerSupport<Plot> {
    static Logger log = Logger.getLogger(PlotSqlTransformer.class.getName());

    public PlotSqlTransformer() {
        this.table = "plots";
    }

    public Class<Plot> getTemplateClass() {
        return Plot.class;
    }

    public String getSelectQuery() {
        return "SELECT ID, title, description, x_title, x_from, x_to, y_title, y_from, y_to FROM " + this.table;
    }

    public Plot create(ResultSet resultSet, Connection connection) throws Exception {
        ResultSet seriesRS;
        Plot pl = new Plot((DataCollection<?>)this.owner, resultSet.getString(1));
        try {
            pl.setTitle(resultSet.getString(2));
            pl.setDescription(resultSet.getString(3));
            pl.setXTitle(resultSet.getString(4));
            pl.setXFrom(resultSet.getDouble(5));
            pl.setXTo(resultSet.getDouble(6));
            pl.setYTitle(resultSet.getString(7));
            pl.setYFrom(resultSet.getDouble(8));
            pl.setYTo(resultSet.getDouble(9));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error occured when initializing simulation result: " + ex);
            return pl;
        }
        try {
            Statement statement = connection.createStatement();
            seriesRS = statement.executeQuery("SELECT spec, legend, x_var, y_var, simulationResultId, sourceNature FROM plot_series WHERE plotId = '" + pl.getName() + "'");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error has occurred when preparing query for \"plot_series\" table: " + ex);
            return pl;
        }
        try {
            while (seriesRS.next()) {
                try {
                    Series s = new Series();
                    s.setPlotName(pl.getName());
                    s.setSpec(Pen.createInstance((String)seriesRS.getString(1)));
                    s.setLegend(seriesRS.getString(2));
                    s.setXVar(seriesRS.getString(3));
                    s.setYVar(seriesRS.getString(4));
                    s.setSource(seriesRS.getString(5));
                    s.setSourceNature(Series.SourceNature.valueOf(seriesRS.getString(6)));
                    pl.addSeries(s);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error has occured when retrieving tuple from \"plot_series\" table: " + ex);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error has occured when retrieving data from \"plot_series\" table: " + ex);
        }
        return pl;
    }

    public void addInsertCommands(Statement statement, Plot pl) throws SQLException {
        try {
            statement.addBatch("INSERT INTO " + this.table + "(id, title, description, x_title, x_from, x_to, y_title, y_from, y_to) VALUES (" + this.validateValue(pl.getName()) + ", " + this.validateValue(pl.getTitle()) + ", " + this.validateValue(pl.getDescription()) + ", " + this.validateValue(pl.getXTitle()) + ", " + pl.getXFrom() + ", " + pl.getXTo() + ", " + this.validateValue(pl.getYTitle()) + ", " + pl.getYFrom() + ", " + pl.getYTo() + ")");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured when adding query for insertion into " + this.table + " table: " + ex);
            return;
        }
        List<Series> series = pl.getSeries();
        if (series != null) {
            for (Series s : series) {
                try {
                    statement.addBatch("INSERT INTO plot_series (id, plotId, spec, legend, x_var, y_var, simulationResultId, sourceNature) VALUES (" + this.validateValue(pl.getName() + "_" + s.getXVar() + "_" + s.getYVar()) + ", " + this.validateValue(pl.getName()) + ", " + this.validateValue(s.getSpec().toString()) + ", " + this.validateValue(s.getLegend()) + ", " + this.validateValue(s.getXVar()) + ", " + this.validateValue(s.getYVar()) + ", " + this.validateValue(s.getSource()) + ", " + this.validateValue(s.getSourceNature().toString()) + "))");
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error occured when adding insertion query for \"plot_series\" table: " + ex);
                }
            }
        }
    }

    public void addDeleteCommands(Statement statement, String name) throws Exception {
        statement.addBatch("DELETE FROM " + this.table + " WHERE id = '" + name + "'");
        statement.addBatch("DELETE FROM plot_series WHERE plotId = '" + name + "'");
    }

    public String[] getUsedTables() {
        return new String[]{"plot_series", this.table};
    }

    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `plots` (  `id` varchar(20) NOT NULL default '',  `title` varchar(20) default NULL,  `description` text,  `x_title` varchar(20) default NULL,  `x_from` double default NULL,  `x_to` double default NULL,  `y_title` varchar(20) default NULL,  `y_from` double default NULL,  `y_to` double default NULL,  PRIMARY KEY  (`id`)) ENGINE=MyISAM";
        }
        if (tableName.equals("plot_series")) {
            return "CREATE TABLE `plot_series` (  `id` bigint(20) NOT NULL auto_increment,  `plotId` varchar(20) default NULL,  `spec` varchar(20) default NULL,  `legend` text,  `x_var` varchar(20) default NULL,  `y_var` varchar(20) default NULL,  `simulationResultId` varchar(200) default NULL,  `sourceNature` varchar(20) default NULL,   PRIMARY KEY  (`id`)) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

