/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot;

import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementReadException;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graphics.Pen;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class Series
extends Option
implements DataElement {
    protected String name;
    protected String plotName;
    protected Pen spec = null;
    protected String legend = "";
    protected String xPath = "";
    protected String xVar;
    protected String yPath = "";
    protected String yVar;
    private SourceNature sourceNature = SourceNature.SIMULATION_RESULT;
    protected DataElementPath source;

    public Series() {
    }

    public Series(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public String getPlotName() {
        return this.plotName;
    }

    public void setPlotName(String plotName) {
        String oldValue = this.plotName;
        this.plotName = plotName;
        this.firePropertyChange("plotName", oldValue, plotName);
    }

    @PropertyName(value="Specification+")
    @PropertyDescription(value="Specification of plot type")
    public Pen getSpec() {
        return this.spec;
    }

    public void setSpec(Pen spec) {
        Pen oldValue = this.spec;
        this.spec = spec;
        this.firePropertyChange("spec", oldValue, spec);
    }

    @PropertyName(value="Legend")
    @PropertyDescription(value="Description of the plot")
    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        String oldValue = this.legend;
        this.legend = legend;
        this.firePropertyChange("legend", oldValue, legend);
    }

    @PropertyName(value="X Variable")
    @PropertyDescription(value="Variable to be mapped to X axis")
    public String getXVar() {
        return this.xVar;
    }

    public void setXVar(String xVar) {
        this.xVar = xVar;
    }

    @PropertyName(value="X Path")
    @PropertyDescription(value="Path to X variable")
    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String xPath) {
        this.xPath = xPath;
    }

    @PropertyName(value="Y Variable")
    @PropertyDescription(value="Variable that will be mapped to Y axis")
    public String getYVar() {
        return this.yVar;
    }

    public void setYVar(String yVar) {
        this.yVar = yVar;
    }

    @PropertyName(value="Y Path")
    @PropertyDescription(value="Path to Y variable")
    public String getYPath() {
        return this.yPath;
    }

    public void setYPath(String yPath) {
        this.yPath = yPath;
    }

    @PropertyName(value="Source")
    @PropertyDescription(value="Name of source, comprising required data")
    public String getSource() {
        return this.source.toString();
    }

    public void setSource(String source) {
        this.source = DataElementPath.create((String)source);
    }

    public SourceNature getSourceNature() {
        return this.sourceNature;
    }

    public void setSourceNature(SourceNature sourceNature) {
        this.sourceNature = sourceNature;
    }

    public DataCollection getOrigin() {
        return null;
    }

    public int getValuesCount() {
        try {
            switch (this.sourceNature) {
                case SIMULATION_RESULT: {
                    return ((SimulationResult)this.source.getDataElement(SimulationResult.class)).getCount();
                }
                case EXPERIMENTAL_DATA: {
                    return ((TableDataCollection)this.source.getDataElement(TableDataCollection.class)).getSize();
                }
            }
            throw new InternalException("Incorrect sourceNature");
        }
        catch (Exception e) {
            throw new DataElementReadException((Throwable)e, (DataElement)this, (Object)"values count");
        }
    }

    public double[] getXValues() {
        return this.getValues(this.getXPath().isEmpty() ? this.getXVar() : this.getXPath() + "/" + this.getXVar());
    }

    public double[] getYValues() {
        return this.getValues(this.getYPath().isEmpty() ? this.getYVar() : this.getYPath() + "/" + this.getYVar());
    }

    private double[] getValues(String varName) {
        try {
            switch (this.sourceNature) {
                case SIMULATION_RESULT: {
                    SimulationResult result = (SimulationResult)this.source.getDataElement(SimulationResult.class);
                    if (varName.equals("time")) {
                        return result.getTimes();
                    }
                    int varIndex = result.getVariablePathMap().get(varName);
                    int size = result.getCount();
                    double[] resValues = new double[size];
                    double[][] values = result.getValues();
                    for (int i = 0; i < size; ++i) {
                        resValues[i] = values[i][varIndex];
                    }
                    return resValues;
                }
                case EXPERIMENTAL_DATA: {
                    return TableDataCollectionUtils.getColumn((TableDataCollection)((TableDataCollection)this.source.getDataElement(TableDataCollection.class)), (String)varName);
                }
            }
            throw new InternalException("Incorrect sourceNature");
        }
        catch (Exception e) {
            throw new DataElementReadException((Throwable)e, (DataElement)this, (Object)"values");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Series other = (Series)((Object)obj);
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        return this.xVar.equals(other.getXVar()) && this.xPath.equals(other.getXPath()) && this.yVar.equals(other.getYVar()) && this.yPath.equals(other.getYPath());
    }

    public static enum SourceNature {
        SIMULATION_RESULT,
        EXPERIMENTAL_DATA;

    }
}

