/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot;

import biouml.standard.simulation.plot.Series;
import biouml.standard.type.BaseSupport;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.swing.table.AbstractRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.font.ColorFont;

@ClassIcon(value="resources/plot.gif")
public class Plot
extends BaseSupport {
    protected List<Series> series;
    protected String description;
    protected String xTitle;
    protected String yTitle;
    protected String yAxisType = AxisType.toString(AxisType.NUMBER);
    protected String xAxisType = AxisType.toString(AxisType.NUMBER);
    protected double xTo;
    protected double yTo;
    protected double xFrom;
    protected double yFrom;
    protected boolean xAutoRange;
    protected boolean yAutoRange;
    protected ColorFont xTickLabelFont = new ColorFont("SansSerif", 0, 12);
    protected ColorFont yTickLabelFont = new ColorFont("SansSerif", 0, 12);
    protected ColorFont xTitleFont = new ColorFont("SansSerif", 0, 12);
    protected ColorFont yTitleFont = new ColorFont("SansSerif", 0, 12);
    private DataElementPath defaultSource;
    protected SeriesRowModel rowModel = new SeriesRowModel();
    private boolean needUpdate = false;

    public Plot(DataCollection<?> origin, String name, List<Series> series) {
        super(origin, name, "plot");
        this.prepareSeries(series);
        this.series = series;
    }

    public Plot(DataCollection<?> origin, String name) {
        super(origin, name);
        this.series = new ArrayList<Series>();
    }

    private void prepareSeries(List<Series> series) {
        for (Series s : series) {
            s.setParent((Option)this);
        }
    }

    public List<Series> getSeries() {
        return this.series;
    }

    public void removeAllSeries() {
        if (this.series.size() > 0) {
            int to = this.series.size() - 1;
            for (int i = 0; i <= to; ++i) {
                Series s = this.series.get(i);
                s.setParent(null);
            }
            this.series.clear();
            this.rowModel.fireTableRowsDeleted(0, to);
        }
    }

    public void addSeries(Series s) {
        int row = this.series.size();
        this.series.add(s);
        s.setParent((Option)this);
        this.rowModel.fireTableRowsInserted(row, row);
    }

    public void removeSeries(int index) {
        Series s = this.series.remove(index);
        if (s != null) {
            s.setParent(null);
        }
        this.rowModel.fireTableRowsDeleted(index, index);
    }

    @Override
    @PropertyName(value="Title")
    @PropertyDescription(value="Title of the plot, how it will be named in the picture.")
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        String oltTitle = this.title;
        this.title = title;
        this.firePropertyChange("title", oltTitle, title);
    }

    @PropertyName(value="Description")
    @PropertyDescription(value="Description of the current plot.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDescription = description;
        this.description = description;
        this.firePropertyChange("description", oldDescription, description);
    }

    @PropertyName(value="X axis title")
    @PropertyDescription(value="Title of X axis of the plot.")
    public String getXTitle() {
        return this.xTitle;
    }

    public void setXTitle(String xTitle) {
        String oldXTitle = this.xTitle;
        this.xTitle = xTitle;
        this.firePropertyChange("xTitle", oldXTitle, xTitle);
    }

    @PropertyName(value="X axis title font")
    @PropertyDescription(value="Font for title of X axis of the plot.")
    public ColorFont getXTitleFont() {
        return this.xTitleFont;
    }

    public void setXTitleFont(ColorFont xTitleFont) {
        ColorFont oldXTitleFont = this.xTitleFont;
        this.xTitleFont = xTitleFont;
        this.firePropertyChange("xTitleFont", oldXTitleFont, xTitleFont);
    }

    @PropertyName(value="X axis type")
    @PropertyDescription(value="Type of X axis of the plot.")
    public String getXAxisType() {
        return this.xAxisType;
    }

    public boolean isXAxisTypeLogarithmic() {
        return this.xAxisType.equals(AxisType.toString(AxisType.LOGARITHMIC));
    }

    public void setXAxisType(String xAxisType) {
        this.xAxisType = xAxisType;
        if (this.isXAxisTypeLogarithmic()) {
            this.setXAutoRange(false);
        } else {
            this.firePropertyChange("*", null, null);
        }
    }

    @PropertyName(value="Y axis type")
    @PropertyDescription(value="Type of Y axis of the plot.")
    public String getYAxisType() {
        return this.yAxisType;
    }

    public void setYAxisType(String yAxisType) {
        this.yAxisType = yAxisType;
        if (this.isYAxisTypeLogarithmic()) {
            this.setYAutoRange(false);
        } else {
            this.firePropertyChange("*", null, null);
        }
    }

    public boolean isYAxisTypeLogarithmic() {
        return this.yAxisType.equals(AxisType.toString(AxisType.LOGARITHMIC));
    }

    @PropertyName(value="X axis auto range")
    @PropertyDescription(value="X axis auto range.")
    public boolean isXAutoRange() {
        return this.xAutoRange;
    }

    public void setXAutoRange(boolean xAutoRange) {
        this.xAutoRange = xAutoRange;
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="   X: to ")
    @PropertyDescription(value="Largest value of X coordinate.")
    public double getXTo() {
        return this.xTo;
    }

    public void setXTo(double xTo) {
        double oldXTo = this.xTo;
        this.xTo = xTo;
        this.firePropertyChange("xTo", oldXTo, xTo);
    }

    @PropertyName(value="   X: from")
    @PropertyDescription(value="Smallest value of X coordinate.")
    public double getXFrom() {
        return this.xFrom;
    }

    public void setXFrom(double xFrom) {
        double oldXFrom = this.xFrom;
        this.xFrom = xFrom;
        this.firePropertyChange("xFrom", oldXFrom, xFrom);
    }

    @PropertyName(value="X axis tick font")
    @PropertyDescription(value="X axis tick label font.")
    public ColorFont getXTickLabelFont() {
        return this.xTickLabelFont;
    }

    public void setXTickLabelFont(ColorFont xTickLabelFont) {
        ColorFont oldValue = this.xTickLabelFont;
        this.xTickLabelFont = xTickLabelFont;
        this.firePropertyChange("xTickLabelFont", oldValue, xTickLabelFont);
    }

    @PropertyName(value="Y axis title")
    @PropertyDescription(value="Title of Y axis of the plot.")
    public String getYTitle() {
        return this.yTitle;
    }

    public void setYTitle(String yTitle) {
        String oldYTitle = this.yTitle;
        this.yTitle = yTitle;
        this.firePropertyChange("yTitle", oldYTitle, yTitle);
    }

    @PropertyName(value="Y axis title font")
    @PropertyDescription(value="Font for title of YX axis of the plot.")
    public ColorFont getYTitleFont() {
        return this.yTitleFont;
    }

    public void setYTitleFont(ColorFont yTitleFont) {
        ColorFont oldYTitleFont = this.yTitleFont;
        this.yTitleFont = yTitleFont;
        this.firePropertyChange("yTitleFont", oldYTitleFont, yTitleFont);
    }

    @PropertyName(value="Y axis auto range")
    @PropertyDescription(value="Y axis auto range.")
    public boolean isYAutoRange() {
        return this.yAutoRange;
    }

    public void setYAutoRange(boolean yAutoRange) {
        this.yAutoRange = yAutoRange;
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="   Y: to ")
    @PropertyDescription(value="Largest value of Y coordinate.")
    public double getYTo() {
        return this.yTo;
    }

    public void setYTo(double yTo) {
        double oldYTo = this.yTo;
        this.yTo = yTo;
        this.firePropertyChange("yTo", oldYTo, yTo);
    }

    @PropertyName(value="   Y: from ")
    @PropertyDescription(value="Smallest value of Y coordinate.")
    public double getYFrom() {
        return this.yFrom;
    }

    public void setYFrom(double yFrom) {
        double oldYFrom = this.yFrom;
        this.yFrom = yFrom;
        this.firePropertyChange("yFrom", oldYFrom, yFrom);
    }

    @PropertyName(value="Y axis tick font")
    @PropertyDescription(value="Y axis tick label font.")
    public ColorFont getYTickLabelFont() {
        return this.yTickLabelFont;
    }

    public void setYTickLabelFont(ColorFont yTickLabelFont) {
        ColorFont oldValue = this.yTickLabelFont;
        this.yTickLabelFont = yTickLabelFont;
        this.firePropertyChange("yTickLabelFont", oldValue, yTickLabelFont);
    }

    public RowModel getRowModel() {
        return this.rowModel;
    }

    public static Series getDefaultSeries(String xName, String yName, String selectedResultName, Series.SourceNature sourceNature) {
        Series s = new Series();
        s.setSource(selectedResultName);
        s.setSourceNature(sourceNature);
        s.setXVar(xName);
        s.setYVar(yName);
        return s;
    }

    public static Series getDefaultSeries(String xPath, String xName, String yPath, String yName, String selectedResultName, Series.SourceNature sourceNature) {
        Series s = new Series();
        s.setSource(selectedResultName);
        s.setSourceNature(sourceNature);
        s.setXPath(xPath);
        s.setXVar(xName);
        s.setYPath(yPath);
        s.setYVar(yName);
        return s;
    }

    public static Series getDefaultSeries() {
        Series s = new Series();
        s.setSource("");
        s.setXVar("");
        s.setYVar("");
        return s;
    }

    public static Plot createDefaultPlot(DataCollection<?> plotCollection) {
        Plot pl = new Plot(plotCollection, "new_plot");
        pl.setTitle("");
        pl.setDescription("");
        pl.setXTitle("");
        pl.setXTitleFont(new ColorFont("SansSerif", 0, 12));
        pl.setYTitle("");
        pl.setXAutoRange(true);
        pl.setYAutoRange(true);
        pl.setXFrom(0.0);
        pl.setYFrom(0.0);
        pl.setXTo(10.0);
        pl.setYTo(10.0);
        return pl;
    }

    public boolean needUpdate() {
        return this.needUpdate;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    @Override
    public Plot clone(DataCollection<?> origin, String newName) {
        Plot plot = new Plot(origin, newName, this.getSeries());
        plot.setTitle(this.getTitle());
        plot.setDescription(this.getDescription());
        plot.setXTitle(this.getXTitle());
        plot.setXTitleFont(this.getXTitleFont());
        plot.setYTitle(this.getYTitle());
        plot.setXTo(this.getXTo());
        plot.setYTo(this.getYTo());
        plot.setXFrom(this.getXFrom());
        plot.setYFrom(this.getYFrom());
        plot.setXAutoRange(this.isXAutoRange());
        plot.setYAutoRange(this.isYAutoRange());
        plot.setDefaultSource(this.getDefaultSource());
        return plot;
    }

    @PropertyName(value="Default source path")
    @PropertyDescription(value="Default path to plot series")
    public DataElementPath getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultSource(DataElementPath source) {
        DataElementPath oldValue = this.defaultSource;
        this.defaultSource = source;
        this.firePropertyChange("defaultSource", oldValue, source);
    }

    public static enum AxisType {
        NUMBER,
        LOGARITHMIC,
        LOG10;


        public static String toString(AxisType axisType) {
            switch (axisType) {
                case NUMBER: {
                    return "Number";
                }
                case LOGARITHMIC: {
                    return "Logarithmic";
                }
                case LOG10: {
                    return "Log 10";
                }
            }
            return "";
        }

        @Nonnull
        public static List<String> getAxisTypes() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(AxisType.toString(NUMBER));
            list.add(AxisType.toString(LOGARITHMIC));
            list.add(AxisType.toString(LOG10));
            return list;
        }

        public static AxisType getAxisType(String axisType) {
            int index = AxisType.getAxisTypes().indexOf(axisType);
            return AxisType.values()[index];
        }
    }

    class SeriesRowModel
    extends AbstractRowModel {
        SeriesRowModel() {
        }

        public int size() {
            if (Plot.this.series != null) {
                return Plot.this.series.size();
            }
            return 0;
        }

        public Object getBean(int index) {
            if (Plot.this.series.size() == 0) {
                return Plot.getDefaultSeries();
            }
            return Plot.this.series.get(index);
        }

        public Class<?> getBeanClass() {
            return Plot.class;
        }
    }
}

