/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.plot;

import biouml.standard.simulation.SimulationDataGenerator;
import biouml.standard.simulation.plot.Series;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.mozilla.javascript.EcmaError;

public class DataGeneratorSeries
extends Series {
    private SimulationDataGenerator xGenerator;
    private SimulationDataGenerator yGenerator;
    private int lastPointCount = 0;
    private Listener listener = new Listener();

    public DataGeneratorSeries() {
    }

    public DataGeneratorSeries(String name) {
        super(name);
    }

    public SimulationDataGenerator getXGenerator() {
        return this.xGenerator;
    }

    public void setXGenerator(SimulationDataGenerator xGenerator) {
        if (this.xGenerator != null) {
            this.xGenerator.removePropertyChangeListener(this.listener);
        }
        this.xGenerator = xGenerator;
        if (this.xGenerator != null) {
            this.xGenerator.addPropertyChangeListener(this.listener);
        }
        this.firePropertyChange("plotData", null, null);
    }

    public SimulationDataGenerator getYGenerator() {
        return this.yGenerator;
    }

    public void setYGenerator(SimulationDataGenerator yGenerator) {
        if (this.yGenerator != null) {
            this.yGenerator.removePropertyChangeListener(this.listener);
        }
        this.yGenerator = yGenerator;
        if (this.yGenerator != null) {
            this.yGenerator.addPropertyChangeListener(this.listener);
        }
        this.firePropertyChange("plotData", null, null);
    }

    @Override
    public String getXVar() {
        return this.xGenerator.getName();
    }

    @Override
    public String getYVar() {
        return this.yGenerator.getName();
    }

    @Override
    public int getValuesCount() {
        return Math.min(this.xGenerator.getPointsCount(), this.yGenerator.getPointsCount());
    }

    @Override
    public double[] getXValues() {
        return this.getValues(this.xGenerator);
    }

    @Override
    public double[] getYValues() {
        return this.getValues(this.yGenerator);
    }

    private double[] getValues(SimulationDataGenerator generator) {
        try {
            int count = this.getValuesCount();
            double[] result = new double[count];
            for (int i = 0; i < count; ++i) {
                try {
                    result[i] = generator.getValue(i);
                    continue;
                }
                catch (Exception e) {
                    result[i] = 0.0;
                }
            }
            return result;
        }
        catch (EcmaError e) {
            throw new RuntimeException("Cannot obtain series: " + e.getErrorMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain series", e);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int currentPointCount = DataGeneratorSeries.this.getValuesCount();
            if (currentPointCount != DataGeneratorSeries.this.lastPointCount) {
                DataGeneratorSeries.this.lastPointCount = currentPointCount;
                DataGeneratorSeries.this.firePropertyChange("plotData", null, null);
            }
        }
    }
}

