/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.access;

import biouml.standard.simulation.SimulationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import ru.biosoft.access.support.TagCommandSupport;
import ru.biosoft.access.support.TagEntryTransformer;

public class VariablesCommand
extends TagCommandSupport<SimulationResult> {
    protected static final Logger log = Logger.getLogger(VariablesCommand.class.getName());
    protected int varCount = -1;

    public VariablesCommand(TagEntryTransformer<SimulationResult> transformer) {
        super("VR", transformer);
    }

    public String getTaggedValue() {
        SimulationResult sr = (SimulationResult)this.transformer.getProcessedObject();
        StringBuilder result = new StringBuilder("VR    time\t");
        Map<String, Integer> variableMap = sr.getVariablePathMap();
        if (variableMap == null) {
            return result.toString();
        }
        Map<Integer, String> invertedVariableMap = this.invert(variableMap);
        CharSequence[] temp = new String[invertedVariableMap.size()];
        for (Map.Entry<Integer, String> entry : invertedVariableMap.entrySet()) {
            int index = entry.getKey();
            if (index >= variableMap.size()) {
                log.log(Level.SEVERE, "Value " + index + " of index in variable map is out of bound.");
                return result.toString();
            }
            temp[entry.getKey().intValue()] = entry.getValue();
        }
        result.append(String.join((CharSequence)"\t", temp));
        return result.toString();
    }

    private Map<Integer, String> invert(Map<String, Integer> varMap) {
        HashMap<Integer, List> temp = new HashMap<Integer, List>();
        for (Map.Entry<String, Integer> entry : varMap.entrySet()) {
            if (entry.getValue() == null) continue;
            temp.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (Map.Entry entry : temp.entrySet()) {
            result.put((Integer)entry.getKey(), ((StreamEx)StreamEx.of((Collection)((Collection)entry.getValue())).sorted()).joining((CharSequence)","));
        }
        return result;
    }

    public void addValue(String string) {
        SimulationResult sr = (SimulationResult)this.transformer.getProcessedObject();
        StringTokenizer strtok = new StringTokenizer(string, "\t");
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        int counter = 0;
        if (strtok.hasMoreTokens()) {
            strtok.nextToken();
        }
        while (strtok.hasMoreTokens()) {
            String str = strtok.nextToken();
            if (str.contains(",")) {
                for (String subStr : str.split(",")) {
                    variableMap.put(subStr, counter);
                }
                ++counter;
                continue;
            }
            variableMap.put(str, counter++);
        }
        sr.setVariableMap(variableMap);
        sr.setVariablePathMap(variableMap);
        this.varCount = counter;
    }

    public int getVarCount() {
        return this.varCount;
    }
}

