/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation.access;

import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.access.VariablesCommand;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.DoubleStreamEx;
import ru.biosoft.access.support.TagCommandSupport;
import ru.biosoft.access.support.TagEntryTransformer;

public class ResultValuesCommand
extends TagCommandSupport<SimulationResult> {
    protected static final Logger log = Logger.getLogger(VariablesCommand.class.getName());
    protected VariablesCommand varCommand;
    private TDoubleList times;
    private List<double[]> values;

    public ResultValuesCommand(TagEntryTransformer<SimulationResult> transformer, VariablesCommand varCommand) {
        super("VL", transformer);
        this.varCommand = varCommand;
    }

    public String getTaggedValue() {
        int varCount;
        String endl = System.getProperty("line.separator");
        SimulationResult sr = (SimulationResult)this.transformer.getProcessedObject();
        StringBuffer result = new StringBuffer();
        double[] times = sr.getTimes();
        double[][] values = sr.getValues();
        if (values == null) {
            return "";
        }
        int n = varCount = values.length > 0 ? values[0].length : 0;
        if (varCount == 0) {
            return result.toString();
        }
        for (int timeSliceNumber = 0; timeSliceNumber < times.length; ++timeSliceNumber) {
            result.append("VL    " + times[timeSliceNumber] + "\t");
            result.append(DoubleStreamEx.of((double[])values[timeSliceNumber]).joining((CharSequence)"\t", (CharSequence)"", (CharSequence)endl));
        }
        return result.toString();
    }

    public void start(String tag) {
        this.times = new TDoubleArrayList();
        this.values = new ArrayList<double[]>();
    }

    public void addValue(String string) {
        StringTokenizer strtok = new StringTokenizer(string, "\t");
        if (this.varCommand.getVarCount() != strtok.countTokens() - 1) {
            log.log(Level.SEVERE, "Error: Bad variable number in line " + string + "variable count: " + this.varCommand.getVarCount());
            return;
        }
        if (strtok.hasMoreTokens()) {
            String currentToken = strtok.nextToken();
            try {
                this.times.add(Double.parseDouble(currentToken));
                double[] val = new double[this.varCommand.getVarCount()];
                int counter = 0;
                while (strtok.hasMoreTokens()) {
                    currentToken = strtok.nextToken();
                    val[counter++] = Double.parseDouble(currentToken);
                }
                this.values.add(val);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Could not parse value " + currentToken);
            }
        }
    }

    public void complete(String str) {
        double[] timeArray = this.times.toArray();
        double[][] valueArray = (double[][])this.values.toArray((T[])new double[this.values.size()][]);
        SimulationResult sr = (SimulationResult)this.transformer.getProcessedObject();
        sr.setTimes(timeArray);
        sr.setValues(valueArray);
    }
}

