/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.plugins.simulation.CycledResultListener;
import biouml.standard.simulation.SimulationResult;
import java.util.Arrays;
import ru.biosoft.access.core.DataCollection;

public class StochasticSimulationResult
extends SimulationResult
implements CycledResultListener {
    public static String TYPE_STOCHASTIC = "Stochastic";
    private double[][][] fullValues;
    private double[][] median;
    private double[][] q1;
    private double[][] q3;
    private int cycle = 0;
    private int cycles;
    private int index = 0;
    private int vars;

    public StochasticSimulationResult(DataCollection<?> origin, String name) {
        super(origin, name);
    }

    public StochasticSimulationResult(DataCollection<?> origin, String name, int cycles, int tPoints) {
        super(origin, name);
        this.size = tPoints;
        this.cycles = cycles;
    }

    public void setVars(int vars) {
        this.vars = vars;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    @Override
    public String getType() {
        return TYPE_STOCHASTIC;
    }

    @Override
    public void add(double t, double[] y) {
        for (int i = 0; i < y.length; ++i) {
            this.fullValues[this.index][i][this.cycle] = y[i];
        }
        this.times[this.index] = t;
        ++this.index;
    }

    public void startCycle() {
        ++this.cycle;
        this.index = 0;
    }

    public void start(Object model) {
        this.cycle = 0;
        this.index = 0;
        this.times = new double[this.size];
        this.fullValues = new double[this.size][this.vars][this.cycles];
        this.median = new double[this.size][this.vars];
        this.values = new double[this.size][this.vars];
        this.q1 = new double[this.size][this.vars];
        this.q3 = new double[this.size][this.vars];
    }

    public void finish() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.vars; ++j) {
                double[] vals = this.fullValues[i][j];
                Arrays.parallelSort(vals);
                if (vals.length < 3) continue;
                this.q1[i][j] = StochasticSimulationResult.quartile1(vals);
                this.median[i][j] = StochasticSimulationResult.median(vals);
                this.q3[i][j] = StochasticSimulationResult.quartile3(vals);
                this.values[i][j] = StochasticSimulationResult.mean(vals);
            }
        }
    }

    @Override
    public double[] getTimes() {
        return this.times;
    }

    @Override
    public double[][] getValues() {
        return this.values;
    }

    public void setMedian(double[][] median) {
        this.median = median;
    }

    public void setQ1(double[][] q1) {
        this.q1 = q1;
    }

    public void setQ3(double[][] q3) {
        this.q3 = q3;
    }

    public double[][] getMedian() {
        return this.median;
    }

    public double[][] getQ1() {
        return this.q1;
    }

    public double[][] getQ3() {
        return this.q3;
    }

    public double[] getMedian(int point) {
        return this.median[point];
    }

    public double[] getQ1(int point) {
        return this.q1[point];
    }

    public double[] getQ3(int point) {
        return this.q3[point];
    }

    public static double quartile1(double[] array) {
        int size = array.length;
        return size % 2 == 1 ? StochasticSimulationResult.median(array, 0, (size - 1) / 2) : StochasticSimulationResult.median(array, 0, size / 2);
    }

    public static double mean(double[] array) {
        double sum = 0.0;
        for (double s : array) {
            sum += s;
        }
        return sum / (double)array.length;
    }

    public static double median(double[] array) {
        return StochasticSimulationResult.median(array, 0, array.length);
    }

    public static double median(double[] array, int start, int end) {
        int size = end - start;
        return size % 2 == 1 ? array[start + (size - 1) / 2] : (array[start + size / 2] + array[start + size / 2 - 1]) * 0.5;
    }

    public static double quartile3(double[] array) {
        int size = array.length;
        return size % 2 == 1 ? StochasticSimulationResult.median(array, (size + 1) / 2, size) : StochasticSimulationResult.median(array, size / 2, size);
    }

    public void addAsFirst(double t, double[] y) {
    }

    public void update(double t, double[] y) {
    }

    @Override
    public StochasticSimulationResult clone(DataCollection origin, String name) {
        StochasticSimulationResult simulationResult = new StochasticSimulationResult(origin, name, this.cycles, this.size);
        simulationResult.setVars(this.vars);
        simulationResult.setTimes(this.getTimes());
        simulationResult.setValues(this.getValues());
        simulationResult.q1 = this.q1;
        simulationResult.q3 = this.q3;
        simulationResult.median = this.median;
        simulationResult.fullValues = this.fullValues;
        simulationResult.values = this.values;
        simulationResult.setDiagramPath(this.getDiagramPath());
        simulationResult.setDescription(this.getDescription());
        simulationResult.setCompletionTime(this.getCompletionTime());
        simulationResult.setInitialTime(this.getInitialTime());
        simulationResult.setSimulatorName(this.getSimulatorName());
        simulationResult.setTitle(this.getTitle());
        simulationResult.setVariableMap(this.getVariableMap());
        simulationResult.setVariablePathMap(this.getVariablePathMap());
        return simulationResult;
    }

    @Override
    public void setValues(String v, double[] values) {
        int index = (Integer)this.variablePathMap.get(v);
        for (int i = 0; i < this.times.length; ++i) {
            this.fullValues[i][index][this.cycle] = values[i];
        }
    }
}

