/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.StreamEx;

public class SimulationResultUtils {
    public static void write(SimulationResult result, String filePath) throws IOException {
        File f = new File(filePath);
        try (BufferedWriter bw = ApplicationUtils.utfAppender((File)f);){
            Object[] variables = result.getVariables();
            double[] times = result.getTimes();
            double[][] values = result.getValues();
            bw.write(StreamEx.of((Object[])variables).prepend((Object)"Time").joining((CharSequence)"\t"));
            bw.write("\n");
            for (int i = 0; i < times.length; ++i) {
                bw.write(DoubleStreamEx.of((double[])values[i]).prepend(new double[]{times[i]}).joining((CharSequence)"\t"));
                bw.write("\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void write(SimulationResult result, String[] variables, String filePath) throws IOException {
        File f = new File(filePath);
        try (BufferedWriter bw = ApplicationUtils.utfAppender((File)f);){
            double[] times = result.getTimes();
            double[][] values = result.getValues(variables);
            bw.write(StreamEx.of((Object[])variables).prepend((Object)"Time").joining((CharSequence)"\t"));
            bw.write("\n");
            for (int i = 0; i < times.length; ++i) {
                bw.write(DoubleStreamEx.of((double[])values[i]).prepend(new double[]{times[i]}).joining((CharSequence)"\t"));
                bw.write("\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toString(SimulationResult result, String[] variables) throws IOException {
        StringBuilder sb = new StringBuilder();
        double[] times = result.getTimes();
        double[][] values = result.getValuesTransposed(variables);
        sb.append(StreamEx.of((Object[])variables).prepend((Object)"Time").joining((CharSequence)"\t"));
        sb.append("\n");
        for (int i = 0; i < times.length; ++i) {
            sb.append(DoubleStreamEx.of((double[])values[i]).prepend(new double[]{times[i]}).joining((CharSequence)"\t"));
            sb.append("\n");
        }
        return sb.toString();
    }
}

