/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.standard.simulation.SimulationResult;
import biouml.standard.simulation.access.SimulationResultTransformer;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementImporter;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class SimulationResultImporter
implements DataElementImporter {
    public int accept(DataCollection parent, File file) {
        if (parent == null || !parent.isMutable() || !DataCollectionUtils.isAcceptable((DataCollection)parent, this.getResultType())) {
            return 0;
        }
        return file == null ? 20 : 0;
    }

    public DataElement doImport(@Nonnull DataCollection parent, @Nonnull File file, String elementName, FunctionJobControl jobControl, Logger log) throws Exception {
        String baseName;
        String name;
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        if (parent.get(name = (baseName = elementName == null || elementName.equals("") ? file.getName().replaceFirst("\\.[^\\.]+$", "") : elementName)) != null) {
            log.warning("File with name " + elementName + " already exists. Imoport denied.");
            return null;
        }
        SimulationResultTransformer transformer = new SimulationResultTransformer();
        transformer.init(null, (DataCollection<SimulationResult>)parent);
        DataElement result = transformer.load(file, elementName, parent);
        parent.put(result);
        if (jobControl != null && jobControl.getStatus() != 4 && jobControl.getStatus() != 5) {
            jobControl.setPreparedness(100);
            jobControl.functionFinished();
        }
        return parent.get(name);
    }

    public boolean init(Properties properties) {
        return true;
    }

    public Object getProperties(DataCollection<?> parent, File file, String elementName) {
        return null;
    }

    public Class<? extends DataElement> getResultType() {
        return SimulationResult.class;
    }
}

