/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.standard.diagram.Util;
import biouml.standard.simulation.MathUtils;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResultSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public class SimulationResult
extends SimulationResultSupport {
    public static final String TYPE_SIMPLE = "Simple";
    private List<ResultListener> listeners = new ArrayList<ResultListener>();
    protected double[] times = new double[10];
    protected double[][] values = new double[10][];
    int size = 0;

    @Override
    public String getType() {
        return TYPE_SIMPLE;
    }

    public SimulationResult(DataCollection<?> origin, String name) {
        super(origin, name);
    }

    public void addResultListener(ResultListener listener) {
        this.listeners.add(listener);
    }

    public void removeResultListener(ResultListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public SimulationResult clone(DataCollection origin, String name) {
        SimulationResult simulationResult = new SimulationResult((DataCollection<?>)origin, name);
        simulationResult.setTimes(this.getTimes());
        simulationResult.setValues(this.getValues());
        simulationResult.setDiagramPath(this.getDiagramPath());
        simulationResult.setDescription(this.getDescription());
        simulationResult.setCompletionTime(this.getCompletionTime());
        simulationResult.setInitialTime(this.getInitialTime());
        simulationResult.setSimulatorName(this.getSimulatorName());
        simulationResult.setTitle(this.getTitle());
        simulationResult.setVariableMap(this.getVariableMap());
        simulationResult.setVariablePathMap(this.getVariablePathMap());
        return simulationResult;
    }

    private void compactify() {
        if (this.times.length > this.size) {
            double[] newTimes = new double[this.size];
            System.arraycopy(this.times, 0, newTimes, 0, this.size);
            this.times = newTimes;
        }
        if (this.values.length > this.size) {
            double[][] newValues = new double[this.size][];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }
    }

    private void realloc() {
        if (this.times.length == this.size) {
            int newAllocSize = Math.max(this.size * 3 / 2, 10);
            double[] newTimes = new double[newAllocSize];
            System.arraycopy(this.times, 0, newTimes, 0, this.size);
            this.times = newTimes;
            double[][] newValues = new double[newAllocSize][];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }
    }

    public double[] getTimes() {
        this.compactify();
        return this.times;
    }

    public double getTime(int point) {
        return this.times[point];
    }

    public void setTimes(double[] times) {
        this.times = times;
        this.size = this.times.length;
    }

    public double[][] getValues() {
        this.compactify();
        return this.values;
    }

    public double[] getValue(int point) {
        return this.values[point];
    }

    public void setValues(double[][] values) {
        this.values = values;
        this.size = this.values.length;
    }

    public int getCount() {
        return this.size;
    }

    public void add(double t, double[] v) {
        this.realloc();
        this.times[this.size] = t;
        this.values[this.size] = v;
        ++this.size;
        int count = this.listeners.size();
        for (int i = 0; i < count; ++i) {
            try {
                this.listeners.get(i).add(t, v);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isNotFilled() {
        return this.size == 1;
    }

    public SimulationResult approximate(double initialTime, double completionTime, double timeIncrement) {
        if (timeIncrement == 0.0) {
            return null;
        }
        if (this.times == null || this.times.length < 2) {
            return null;
        }
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        SimulationResult result = new SimulationResult((DataCollection<?>)this.getOrigin(), this.getName());
        result.diagramName = this.diagramName;
        result.simulatorName = this.simulatorName;
        result.variableMap = new HashMap(this.variableMap);
        result.variablePathMap = this.variablePathMap == null ? null : new HashMap(this.variablePathMap);
        result.description = this.description + "\r\n Approximated for time interval: " + initialTime + " - " + completionTime + "with step:" + timeIncrement;
        int varCount = this.values[0].length;
        int n = (int)((completionTime - initialTime) / timeIncrement);
        n = initialTime + timeIncrement * (double)n < completionTime ? (n += 2) : ++n;
        result.size = n;
        result.initialValues = (ArrayList)this.initialValues.clone();
        result.times = new double[n];
        result.values = new double[n][varCount];
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            result.times[i] = initialTime + (double)i * timeIncrement;
            if (result.times[i] > completionTime) {
                result.times[i] = completionTime;
            }
            while (pos < this.times.length && result.times[i] > this.times[pos]) {
                ++pos;
            }
            int pos1 = pos == 0 ? 0 : (pos == this.times.length ? this.times.length - 2 : pos - 1);
            double t1 = this.times[pos1];
            double t2 = this.times[pos1 + 1];
            for (int var = 0; var < varCount; ++var) {
                double x1 = this.values[pos1][var];
                double x2 = this.values[pos1 + 1][var];
                result.values[i][var] = (x2 - x1) / (t2 - t1) * (result.times[i] - t1) + x1;
            }
        }
        return result;
    }

    public double[][] interpolateLinear(double[] controlPoints) throws Exception {
        this.compactify();
        if (this.values.length == 0) {
            return null;
        }
        int m = this.values[0].length;
        double[][] interpolatedValues = new double[controlPoints.length][m];
        int[] indexes = MathUtils.multiBinarySearch(this.times, controlPoints);
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < controlPoints.length; ++i) {
                int k = indexes[i];
                if (k < 0) {
                    int index = -k - 1;
                    if (index == 0) {
                        interpolatedValues[i][j] = this.values[0][j];
                        continue;
                    }
                    if (index == this.times.length) {
                        interpolatedValues[i][j] = this.values[this.values.length - 1][j];
                        continue;
                    }
                    double x0 = this.times[index - 1];
                    double f0 = this.values[index - 1][j];
                    if (Double.isInfinite(f0) && Double.isInfinite(this.values[index][j])) {
                        interpolatedValues[i][j] = f0;
                        continue;
                    }
                    interpolatedValues[i][j] = f0 + (this.values[index][j] - f0) * (controlPoints[i] - x0) / (this.times[index] - x0);
                    continue;
                }
                interpolatedValues[i][j] = this.values[k][j];
            }
        }
        return interpolatedValues;
    }

    public double[] getValues(String variableName) {
        return this.getValues(new String[]{variableName})[0];
    }

    public double getFinal(String variableName) {
        return this.getValues(new String[]{variableName})[0][this.size - 1];
    }

    public double getInitial(String variableName) {
        return this.getValues(new String[]{variableName})[0][0];
    }

    public String[] getVariables() {
        String[] result = new String[this.variableShortMap.size()];
        this.variableShortMap.entrySet().forEach(e -> {
            result[((Integer)e.getValue()).intValue()] = (String)e.getKey();
        });
        return result;
    }

    public double[][] getValues(String[] variableNames) {
        this.compactify();
        if (variableNames == null) {
            return null;
        }
        double[][] varValues = new double[variableNames.length][this.times.length];
        for (int i = 0; i < variableNames.length; ++i) {
            int j;
            int ind;
            if (this.variableMap.containsKey(variableNames[i])) {
                ind = (Integer)this.variableMap.get(variableNames[i]);
                for (j = 0; j < this.times.length; ++j) {
                    varValues[i][j] = this.values[j][ind];
                }
                continue;
            }
            if (this.variableShortMap.containsKey(variableNames[i])) {
                ind = (Integer)this.variableShortMap.get(variableNames[i]);
                for (j = 0; j < this.times.length; ++j) {
                    varValues[i][j] = this.values[j][ind];
                }
                continue;
            }
            varValues[i] = null;
        }
        return varValues;
    }

    public double[][] getValuesTransposed(String[] variableNames) {
        this.compactify();
        if (variableNames == null) {
            return null;
        }
        int[] indexes = StreamEx.of((Object[])variableNames).mapToInt(s -> (Integer)this.variableShortMap.get(s)).toArray();
        double[][] varValues = new double[this.times.length][variableNames.length];
        for (int i = 0; i < this.times.length; ++i) {
            for (int j = 0; j < variableNames.length; ++j) {
                varValues[i][j] = this.values[i][indexes[j]];
            }
        }
        return varValues;
    }

    public Set<String> getPaths() {
        HashSet<String> paths = new HashSet<String>();
        for (String name : this.getVariablePathMap().keySet()) {
            String[] components = Util.getMainPathComponents(name);
            paths.add(components[0]);
        }
        return paths;
    }

    @Override
    public void setValues(String v, double[] values) {
        int index = (Integer)this.variablePathMap.get(v);
        for (int i = 0; i < this.times.length; ++i) {
            this.values[i][index] = values[i];
        }
    }
}

