/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.standard.simulation.SimulationResult;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptVariable
extends ScriptableObject {
    private int idx;
    private String name;
    private int count = 0;
    private SimulationResult result;
    private double min;
    private double max;
    private double sum;
    private double product;
    private int skipPoints;

    ScriptVariable(String name, int idx, SimulationResult result, int skipPoints) {
        this.idx = idx;
        this.name = name;
        this.result = result;
        this.skipPoints = skipPoints;
    }

    public Integer getIdx() {
        return this.idx;
    }

    public String getName() {
        return this.name;
    }

    void addValue(double val) {
        if (this.count == 0) {
            this.sum = this.product = val;
            this.max = this.product;
            this.min = this.product;
        } else {
            this.max = Math.max(val, this.max);
            this.min = Math.min(val, this.min);
            this.sum += val;
            this.product *= val;
        }
        ++this.count;
    }

    int count() {
        return this.count;
    }

    public String getClassName() {
        return "variable";
    }

    public int getSkipPoints() {
        return this.skipPoints;
    }

    public Object get(int point, Scriptable start) {
        return this.idx == -1 ? this.result.getTime(point + this.skipPoints) : this.result.getValue(point + this.skipPoints)[this.idx];
    }

    public Object get(String name, Scriptable start) {
        if (name.equals("max")) {
            return this.max;
        }
        if (name.equals("min")) {
            return this.min;
        }
        if (name.equals("sum")) {
            return this.sum;
        }
        if (name.equals("product")) {
            return this.product;
        }
        if (name.equals("count")) {
            return this.count;
        }
        return null;
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.count;
    }

    public boolean has(String name, Scriptable start) {
        return name.equals("max") || name.equals("min") || name.equals("sum") || name.equals("product") || name.equals("count");
    }

    public void put(int index, Scriptable start, Object value) {
        throw new UnsupportedOperationException();
    }

    public void put(String name, Scriptable start, Object value) {
        throw new UnsupportedOperationException();
    }

    public void delete(int index) {
        throw new UnsupportedOperationException();
    }

    public void delete(String name) {
        throw new UnsupportedOperationException();
    }
}

