/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.simulation;

import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.ScriptParameter;
import biouml.standard.simulation.ScriptVariable;
import biouml.standard.simulation.SimulationDataGeneratorSupport;
import biouml.standard.simulation.SimulationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.EntryStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;

public class ScriptDataGenerator
extends SimulationDataGeneratorSupport {
    private String name;
    private DataCollection<?> origin;
    private Script script;
    private Context context;
    private Scriptable scope;
    private String scriptSource;
    private Map<SimulationResult, List<ScriptVariable>> results = new HashMap<SimulationResult, List<ScriptVariable>>();
    private int nPoints = 0;
    private Scriptable buck;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    public static final String VARIABLES_PROPERTY = "variables";
    public static final String SCRIPT_PROPERTY = "script";
    public static final String PARAMETERS_PROPERTY = "parameters";

    public ScriptDataGenerator(DataCollection<?> origin, String name) {
        this(origin, name, null);
    }

    public ScriptDataGenerator(DataCollection<?> origin, String name, String script) {
        this.origin = origin;
        this.name = name;
        this.context = Context.enter();
        this.scope = new ImporterTopLevel();
        this.buck = new NativeObject();
        this.scope.put("$", this.scope, (Object)this.buck);
        this.setScript(script);
    }

    public ScriptDataGenerator(String jsonStr) {
        try {
            JSONObject json = new JSONObject(jsonStr);
            this.fromJSON(json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void setScript(String script) {
        this.scriptSource = script;
        this.script = script == null ? null : this.context.compileString(script, "", 1, null);
    }

    public String getScript() {
        return this.scriptSource;
    }

    public void addVariable(String name, SimulationResult result, String ref, int skipPoints) throws Exception {
        Object idx;
        if (!this.results.containsKey(result)) {
            this.results.put(result, new ArrayList());
            new Listener(result);
        }
        if ((idx = ref == null ? Integer.valueOf(-1) : (result.getVariableMap() == null ? null : result.getVariableMap().get(ref))) == null) {
            throw new Exception("Unknown reference " + ref);
        }
        ScriptVariable variableInfo = new ScriptVariable(name, (Integer)idx, result, skipPoints);
        this.results.get(result).add(variableInfo);
        this.buck.put(name, this.buck, (Object)Context.toObject((Object)((Object)variableInfo), (Scriptable)this.buck));
        if (this.script == null) {
            this.setScript("$['" + StringEscapeUtils.escapeJavaScript((String)name) + "'][point]");
        }
        int count = result.getCount();
        for (int i = skipPoints; i < count; ++i) {
            if (variableInfo.getIdx() == -1) {
                variableInfo.addValue(result.getTime(i));
                continue;
            }
            variableInfo.addValue(result.getValue(i)[variableInfo.getIdx()]);
        }
    }

    public void addParameter(String name, Object value) {
        ScriptParameter parameter = new ScriptParameter(value);
        this.parameters.put(name, value);
        this.buck.put(name, this.buck, (Object)Context.toObject((Object)((Object)parameter), (Scriptable)this.buck));
    }

    private void add(double t, double[] y, SimulationResult result) {
        List<ScriptVariable> list = this.results.get(result);
        if (list == null) {
            return;
        }
        for (ScriptVariable var : list) {
            if (var.getSkipPoints() >= result.getCount()) continue;
            if (var.getIdx() == -1) {
                var.addValue(t);
                continue;
            }
            var.addValue(y[var.getIdx()]);
        }
        int oldNPoints = this.nPoints;
        this.nPoints = Integer.MAX_VALUE;
        for (List<ScriptVariable> list2 : this.results.values()) {
            for (ScriptVariable var : list2) {
                this.nPoints = Math.min(this.nPoints, var.count());
            }
        }
        if (oldNPoints != this.nPoints) {
            this.notifyListeners();
        }
    }

    @Override
    public int getPointsCount() {
        return this.nPoints;
    }

    @Override
    public double getValue(int point) throws Exception {
        this.scope.put("point", this.scope, (Object)point);
        return (Double)this.script.exec(this.context, this.scope);
    }

    public String getName() {
        return this.name;
    }

    public DataCollection<?> getOrigin() {
        return this.origin;
    }

    public Set<SimulationResult> getSimulationResults() {
        return this.results.keySet();
    }

    public List<ScriptVariable> getVariables(SimulationResult result) {
        return this.results.get(result);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        try {
            JSONObject jsonObj = this.toJSON();
            return jsonObj.toString();
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    public void fromJSON(JSONObject json) throws JSONException {
        this.name = json.getString("name");
        if (json.has("origin")) {
            this.origin = CollectionFactory.getDataCollection((String)json.getString("origin"));
        }
        this.context = Context.enter();
        this.scope = new ImporterTopLevel();
        this.buck = new NativeObject();
        this.scope.put("$", this.scope, (Object)this.buck);
        this.setScript(json.getString(SCRIPT_PROPERTY));
        if (json.has(PARAMETERS_PROPERTY)) {
            this.addParametersFromJSONArray(json.getJSONArray(PARAMETERS_PROPERTY));
        }
        if (json.has(VARIABLES_PROPERTY)) {
            this.addVariablesFromJSONArray(json.getJSONArray(VARIABLES_PROPERTY));
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("name", (Object)this.name);
        if (this.origin != null) {
            json.put("origin", (Object)this.origin.getCompletePath().toString());
        }
        json.put(SCRIPT_PROPERTY, (Object)this.getScript());
        if (this.parameters != null) {
            JSONArray params = this.getParametersJSONArray();
            json.put(PARAMETERS_PROPERTY, (Object)params);
        }
        if (this.results != null) {
            JSONArray varArray = this.getVariablesJSONArray();
            json.put(VARIABLES_PROPERTY, (Object)varArray);
        }
        return json;
    }

    private void addVariablesFromJSONArray(JSONArray array) throws JSONException {
        this.addVariablesFromJSONArray(array, null);
    }

    private void addVariablesFromJSONArray(JSONArray array, SimulationResult result) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            JSONArray v = array.getJSONArray(i);
            try {
                DataElement de;
                DataElementPath resultPath = DataElementPath.create((String)v.getString(1));
                if (result != null && !result.getName().equals(resultPath.getName())) continue;
                if (result == null && (de = resultPath.optDataElement()) instanceof SimulationResult) {
                    result = (SimulationResult)de;
                }
                if (result == null) continue;
                String ref = v.getString(2);
                if (ref.equals("null")) {
                    ref = null;
                }
                this.addVariable(v.getString(0), result, ref, v.getInt(3));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addVariablesFromString(String arrayStr) throws JSONException {
        JSONArray array = new JSONArray(arrayStr);
        this.addVariablesFromJSONArray(array);
    }

    public void addVariablesFromString(String arrayStr, SimulationResult result) throws JSONException {
        JSONArray array = new JSONArray(arrayStr);
        this.addVariablesFromJSONArray(array, result);
    }

    private JSONArray getVariablesJSONArray() {
        JSONArray varArray = new JSONArray();
        Set<SimulationResult> results = this.getSimulationResults();
        for (SimulationResult res : results) {
            String resultName = DataElementPath.create((DataElement)res).toString();
            Map<String, Integer> varMap = res.getVariableMap();
            Map revVarMap = EntryStream.of(varMap).invert().toMap();
            for (ScriptVariable var : this.getVariables(res)) {
                JSONArray v = new JSONArray();
                v.put((Object)var.getName());
                String nameInResult = (String)revVarMap.get(var.getIdx());
                v.put((Object)resultName);
                v.put((Object)nameInResult);
                v.put(var.getSkipPoints());
                varArray.put((Object)v);
            }
        }
        return varArray;
    }

    public String getVariablesAsString() {
        return this.getVariablesJSONArray().toString();
    }

    private JSONArray getParametersJSONArray() {
        JSONArray params = new JSONArray();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            JSONArray p = new JSONArray();
            p.put((Object)entry.getKey());
            p.put(entry.getValue());
            params.put((Object)p);
        }
        return params;
    }

    public String getParametersString() {
        return this.getParametersJSONArray().toString();
    }

    private void addParametersFromJSONArray(JSONArray params) throws JSONException {
        for (int i = 0; i < params.length(); ++i) {
            JSONArray p = params.getJSONArray(i);
            this.addParameter(p.getString(0), p.get(1));
        }
    }

    public void addParametersFromString(String paramsStr) throws JSONException {
        this.addParametersFromJSONArray(new JSONArray(paramsStr));
    }

    private class Listener
    implements ResultListener {
        private SimulationResult result;

        public Listener(SimulationResult result) {
            this.result = result;
            result.addResultListener(this);
        }

        @Override
        public void start(Object model) {
        }

        @Override
        public void add(double t, double[] y) throws Exception {
            ScriptDataGenerator.this.add(t, y, this.result);
        }
    }
}

