/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.DiagramElement;
import biouml.standard.filter.Action;
import biouml.standard.filter.ActionFilter;
import biouml.standard.filter.CompositeHighlightAction;
import biouml.standard.filter.HideAction;
import biouml.standard.filter.HighlightAction;
import biouml.standard.filter.ValueAction;
import com.developmentontheedge.beans.Option;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;

public abstract class ValueActionFilter
extends Option
implements ActionFilter {
    public static final String EMPTY_VALUE = "_empty_";
    private final boolean useEmptyValue;
    private boolean enabled = false;
    private ValueAction[] valueActions;

    public ValueActionFilter(Option parent, String[] values, boolean useEmptyValue) {
        super(parent);
        this.useEmptyValue = useEmptyValue;
        StreamEx stream = StreamEx.of((Object[])values).map(val -> new ValueAction(this, (String)val));
        if (useEmptyValue) {
            stream = stream.prepend((Object)new ValueAction(this, EMPTY_VALUE));
        }
        this.valueActions = (ValueAction[])stream.toArray(ValueAction[]::new);
    }

    public boolean isUseEmptyValue() {
        return this.useEmptyValue;
    }

    public abstract String getValue(DataElement var1);

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange("enabled", oldValue, enabled);
    }

    public ValueAction[] getValueAction() {
        return this.valueActions;
    }

    public ValueAction getValueAction(int i) {
        return this.valueActions[i];
    }

    public void setValueAction(ValueAction[] valueActions) {
        ValueAction[] oldValue = valueActions;
        this.valueActions = valueActions;
        this.firePropertyChange("valueAction", oldValue, valueActions);
    }

    public void setValueAction(int i, ValueAction valueAction) {
        ValueAction oldValue = this.valueActions[i];
        this.valueActions[i] = valueAction;
        this.firePropertyChange("valueAction", (Object)oldValue, (Object)valueAction);
    }

    public String getItemDisplayName(Integer index, Object obj) {
        return ((ValueAction)((Object)obj)).getValue();
    }

    @Override
    public Action getAction(DiagramElement de) {
        String value = this.getValue(de.getKernel());
        if (value == null || value.length() == 0) {
            if (this.useEmptyValue && this.valueActions[0].isEnabled()) {
                return this.valueActions[0].getAction();
            }
            return null;
        }
        CompositeHighlightAction composite = null;
        for (ValueAction valueAction : this.valueActions) {
            if (!valueAction.isEnabled() || value.indexOf(valueAction.getValue()) == -1) continue;
            Action action = valueAction.getAction();
            if (action == HideAction.instance) {
                return HideAction.instance;
            }
            if (!(action instanceof HighlightAction)) continue;
            if (composite == null) {
                composite = new CompositeHighlightAction();
            }
            composite.add((HighlightAction)action);
        }
        return composite;
    }
}

