/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.DiagramElement;
import biouml.standard.filter.Action;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;

public class TextMarkAction
implements Action {
    private String mark;
    private String description;

    public TextMarkAction(String mark, String description) {
        this.mark = mark;
        this.description = description;
    }

    private void applyToView(View view) throws AppliedException {
        if (view instanceof TextView) {
            throw new AppliedException();
        }
        if (view instanceof CompositeView) {
            for (View child : (CompositeView)view) {
                this.applyToView(child);
            }
        }
    }

    @Override
    public void apply(DiagramElement de) {
        View view = de.getView();
        try {
            this.applyToView(view);
        }
        catch (AppliedException appliedException) {
            // empty catch block
        }
        if (this.description != null) {
            view.setDescription(view.getDescription() == null ? this.description : view.getDescription() + ": " + this.description);
        }
    }

    private static class AppliedException
    extends Exception {
        private AppliedException() {
        }
    }
}

