/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.filter.CompositeHighlightAction;
import biouml.standard.filter.InnerShapeView;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.GradientBorderedBoxView;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.ShapeView;
import ru.biosoft.graphics.View;
import ru.biosoft.util.Pair;

public class ShapedHighlightAction
extends CompositeHighlightAction {
    private int addX = 20;
    private int addY = 20;
    private boolean useGradientFill = false;

    public ShapedHighlightAction() {
    }

    public ShapedHighlightAction(int radius, boolean useGradientFill) {
        this.addX = radius;
        this.addY = radius;
        this.useGradientFill = useGradientFill;
    }

    private List<Point> cutBySutherlandHodgman(List<Point> points, int xPos, boolean left) {
        ArrayList<Point> result = new ArrayList<Point>();
        Point last = points.get(points.size() - 1);
        for (Point cur : points) {
            if (last.x < xPos ^ cur.x < xPos) {
                result.add(new Point(xPos, (cur.y - last.y) * (xPos - last.x) / (cur.x - last.x) + last.y));
            }
            if (!left ^ cur.x < xPos) {
                result.add(cur);
            }
            last = cur;
        }
        return result;
    }

    @Override
    public void apply(DiagramElement de) {
        InnerShapeView innerShape;
        if (this.actions == null || !(de instanceof Node) || !(de.getOrigin() instanceof Compartment)) {
            return;
        }
        Compartment parent = (Compartment)de.getOrigin();
        CompositeView parentView = (CompositeView)parent.getView();
        View view = de.getView();
        ShapeView baseView = null;
        if (view instanceof ShapeView) {
            baseView = (ShapeView)view;
        } else if (view instanceof CompositeView && (innerShape = InnerShapeView.findBiggestInnerShape((CompositeView)view, -1)) != null) {
            baseView = innerShape.getShapeView();
        }
        if (baseView == null) {
            return;
        }
        double cx = baseView.getBounds().getCenterX();
        double cy = baseView.getBounds().getCenterY();
        AffineTransform at = new AffineTransform();
        at.translate(cx, cy);
        if (!this.useGradientFill) {
            at.scale((baseView.getBounds().getWidth() + (double)(this.addX * 2)) / baseView.getBounds().getWidth(), (baseView.getBounds().getHeight() + (double)(this.addY * 2)) / baseView.getBounds().getHeight());
        }
        at.translate(-cx, -cy);
        PathIterator pathIterator = baseView.getShape().getPathIterator(at, 1.0);
        double[] coords = new double[6];
        ArrayList<Point> points = new ArrayList<Point>();
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            if (type != 4) {
                points.add(new Point((int)coords[0], (int)coords[1]));
            }
            pathIterator.next();
        }
        int n = this.actions.length;
        CompositeView highlighter = new CompositeView();
        double leftX = cx - baseView.getBounds().getWidth() / 2.0 - (double)this.addX - 2.0;
        double rightX = cx + baseView.getBounds().getWidth() / 2.0 + (double)this.addX + 2.0;
        for (int i = 0; i < n; ++i) {
            ArrayList<Point> curPoints = i == 0 ? points : this.cutBySutherlandHodgman(points, (int)((rightX - leftX) * (double)i / (double)n + leftX), false);
            List<Point> list = curPoints = i == n - 1 ? curPoints : this.cutBySutherlandHodgman(curPoints, (int)((rightX - leftX) * (double)(i + 1) / (double)n + leftX), true);
            if (this.useGradientFill) {
                PolygonView poly = new PolygonView(this.actions[i].pen, this.actions[i].brush, curPoints);
                Rectangle rect = poly.getBounds();
                int side = i == 0 ? (n == 1 ? 3 : 2) : (i == n - 1 ? 1 : 0);
                Pair<Float, Float> radius = this.getRadiusForShape(baseView.getShape());
                if (((Float)radius.getFirst()).floatValue() > (float)rect.width) {
                    radius.setFirst((Object)Float.valueOf(rect.width));
                }
                if (((Float)radius.getSecond()).floatValue() > (float)rect.width) {
                    radius.setSecond((Object)Float.valueOf(rect.width));
                }
                GradientBorderedBoxView bw = new GradientBorderedBoxView(this.actions[i].brush, (float)rect.x, (float)rect.y, (float)rect.width, (float)rect.height, ((Float)radius.getFirst()).floatValue(), ((Float)radius.getSecond()).floatValue(), (float)this.addX);
                bw.setSide(side);
                highlighter.add((View)bw);
                continue;
            }
            highlighter.add((View)new PolygonView(this.actions[i].pen, this.actions[i].brush, curPoints));
        }
        highlighter.setModel((Object)this);
        parentView.insert((View)highlighter, this.findHighlightPosition(parentView));
    }

    private Pair<Float, Float> getRadiusForShape(Shape shape) {
        if (shape instanceof RoundRectangle2D) {
            return new Pair((Object)Float.valueOf((float)((RoundRectangle2D)shape).getArcWidth()), (Object)Float.valueOf((float)((RoundRectangle2D)shape).getArcHeight()));
        }
        if (shape instanceof Ellipse2D) {
            float arch;
            float arcw;
            double h;
            double w = ((Ellipse2D)shape).getWidth();
            if (w / (h = ((Ellipse2D)shape).getHeight()) > 1.5) {
                arcw = (float)(h / 2.0);
                arch = (float)(h / 2.0);
            } else if (h / w > 1.5) {
                arcw = (float)(w / 2.0);
                arch = (float)(w / 2.0);
            } else {
                arcw = (float)(w / 2.0);
                arch = (float)(h / 2.0);
            }
            return new Pair((Object)Float.valueOf(arcw), (Object)Float.valueOf(arch));
        }
        return new Pair((Object)Float.valueOf(5.0f), (Object)Float.valueOf(5.0f));
    }

    private int findHighlightPosition(CompositeView cv) {
        for (int i = 0; i < cv.size(); ++i) {
            View v = cv.elementAt(i);
            Object model = v.getModel();
            if (model == null || model.equals(cv.getModel()) || !(model instanceof Node) && !(model instanceof Edge)) continue;
            return i;
        }
        return 0;
    }
}

