/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.DiagramElement;
import biouml.standard.filter.Action;
import biouml.standard.filter.InnerShapeView;
import java.awt.Color;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.ShapeView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;

public class InteriorHighlightAction
implements Action {
    private Brush brush;
    private String description;

    public InteriorHighlightAction(Brush brush, String description) {
        this.brush = brush;
        this.description = description;
    }

    public InteriorHighlightAction(Brush brush) {
        this(brush, null);
    }

    @Override
    public void apply(DiagramElement de) {
        View view = de.getView();
        if (view instanceof ShapeView) {
            ((ShapeView)view).setBrush(this.brush);
        } else if (view instanceof CompositeView) {
            ShapeView biggestView = null;
            InnerShapeView innerShape = InnerShapeView.findBiggestInnerShape((CompositeView)view, -1);
            if (innerShape != null) {
                biggestView = innerShape.getShapeView();
            }
            TextView textView = null;
            for (View childView : (CompositeView)view) {
                if (!(childView instanceof TextView)) continue;
                textView = (TextView)childView;
            }
            if (biggestView != null) {
                biggestView.setBrush(this.brush);
            } else if (textView == null || this.brush.getPaint() instanceof Color) {
                // empty if block
            }
        }
        if (this.description != null) {
            view.setDescription(view.getDescription() == null ? this.description : view.getDescription() + ": " + this.description);
        }
    }
}

