/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.standard.filter.Action;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Iterator;
import java.util.Objects;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.GradientBorderedBoxView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.ShapeView;
import ru.biosoft.graphics.View;

public class HighlightAction
implements Action {
    private int addX = 20;
    private int addY = 20;
    protected String description;
    protected Brush brush;
    protected Pen pen;

    public HighlightAction() {
        this.brush = new Brush((Paint)new Color(255, 255, 255));
        this.pen = null;
    }

    public HighlightAction(Brush brush) {
        this.brush = brush;
        this.pen = null;
    }

    public HighlightAction(Brush brush, Pen pen) {
        this.brush = brush;
        this.pen = pen;
    }

    public HighlightAction(Brush brush, Pen pen, String description, int radius) {
        this.brush = brush;
        this.pen = pen;
        this.description = description;
        this.addX = radius;
        this.addY = radius;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setBrush(Brush brush) {
        this.brush = brush;
    }

    public Pen getPen() {
        return this.pen;
    }

    public void setPen(Pen pen) {
        this.pen = pen;
    }

    @Override
    public void apply(DiagramElement de) {
        if (de instanceof Node && de.getOrigin() instanceof Compartment) {
            Node node = (Node)de;
            Compartment parent = (Compartment)de.getOrigin();
            CompositeView parentView = (CompositeView)parent.getView();
            View view = de.getView();
            ShapeView baseView = null;
            if (view instanceof ShapeView) {
                baseView = (ShapeView)view;
            } else if (view instanceof CompositeView) {
                double maxArea = 0.0;
                for (View childView : (CompositeView)view) {
                    double area = childView.getBounds().getWidth() * childView.getBounds().getHeight();
                    if (!(childView instanceof ShapeView) || !(area > maxArea)) continue;
                    maxArea = area;
                    baseView = (ShapeView)childView;
                }
            }
            if (baseView == null) {
                return;
            }
            Rectangle bounds = (Rectangle)baseView.getBounds().clone();
            Shape shape = baseView.getShape();
            GradientBorderedBoxView highlighter = null;
            highlighter = shape instanceof RoundRectangle2D ? new GradientBorderedBoxView(this.brush, (float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, (float)((RoundRectangle2D)shape).getArcWidth(), (float)((RoundRectangle2D)shape).getArcHeight(), (float)this.addX) : (shape instanceof Ellipse2D ? new GradientBorderedBoxView(this.brush, (float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, (float)((Ellipse2D)shape).getWidth() / 2.0f, (float)((Ellipse2D)shape).getHeight() / 2.0f, (float)this.addX) : new GradientBorderedBoxView(this.brush, (float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, 5.0f, 5.0f, (float)this.addX));
            if (highlighter != null) {
                View view1;
                highlighter.setModel((Object)this);
                if (this.description != null) {
                    highlighter.setDescription(this.description);
                }
                int i = 0;
                Iterator iterator = parentView.iterator();
                while (iterator.hasNext() && (view1 = (View)iterator.next()).getModel() != node) {
                    ++i;
                }
                parentView.insert((View)highlighter, i);
            }
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HighlightAction) {
            Brush brush2 = ((HighlightAction)obj).getBrush();
            Pen pen2 = ((HighlightAction)obj).getPen();
            return this.brush.getPaint().equals(brush2.getPaint()) && Objects.equals(this.pen, pen2);
        }
        return false;
    }
}

