/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.standard.filter.Action;
import biouml.standard.filter.HighlightAction;
import java.awt.Rectangle;
import java.util.Iterator;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;

public class CompositeHighlightAction
implements Action {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static int orientation = 0;
    protected HighlightAction[] actions;

    protected static int lookupNodePosition(CompositeView parentView, Node node) {
        View view;
        int pos = 0;
        Iterator iterator = parentView.iterator();
        while (iterator.hasNext() && (view = (View)iterator.next()).getModel() != node) {
            ++pos;
        }
        return pos;
    }

    public CompositeHighlightAction() {
    }

    public CompositeHighlightAction(HighlightAction[] actions) {
        this.actions = actions;
    }

    public CompositeHighlightAction(Action action1, Action action2) {
        if (action1 instanceof HighlightAction) {
            this.add((HighlightAction)action1);
        } else if (action1 instanceof CompositeHighlightAction) {
            this.add((CompositeHighlightAction)action1);
        }
        if (action2 instanceof HighlightAction) {
            this.add((HighlightAction)action2);
        } else if (action2 instanceof CompositeHighlightAction) {
            this.add((CompositeHighlightAction)action2);
        }
    }

    public HighlightAction[] getActions() {
        return this.actions;
    }

    public void add(HighlightAction action) {
        if (this.actions == null) {
            this.actions = new HighlightAction[1];
            this.actions[0] = action;
            return;
        }
        int length = this.actions.length;
        HighlightAction[] newActions = new HighlightAction[length + 1];
        System.arraycopy(this.actions, 0, newActions, 0, length);
        newActions[length] = action;
        this.actions = newActions;
    }

    public void add(CompositeHighlightAction cha) {
        if (this.actions == null) {
            this.actions = cha.getActions();
        } else {
            StreamEx.of((Object[])cha.actions).forEach(this::add);
        }
    }

    @Override
    public void apply(DiagramElement de) {
        if (this.actions == null) {
            return;
        }
        if (this.actions.length == 1) {
            this.actions[0].apply(de);
            return;
        }
        if (de instanceof Node && de.getOrigin() instanceof Compartment) {
            Node node = (Node)de;
            Compartment parent = (Compartment)de.getOrigin();
            CompositeView parentView = (CompositeView)parent.getView();
            Rectangle bounds = (Rectangle)node.getView().getBounds().clone();
            bounds.grow(20, 20);
            CompositeView highlighter = new CompositeView();
            int n = this.actions.length;
            for (int i = 0; i < n; ++i) {
                int x = orientation == 1 ? bounds.x : bounds.x + bounds.width * i / n;
                int y = orientation == 0 ? bounds.y : bounds.y + bounds.height * i / n;
                int width = orientation == 1 ? bounds.width : bounds.width / n + 1;
                int height = orientation == 0 ? bounds.height : bounds.height / n + 1;
                BoxView view = new BoxView(this.actions[i].pen, this.actions[i].brush, x, y, width, height);
                highlighter.add((View)view);
            }
            highlighter.setModel((Object)this);
            parentView.insert((View)highlighter, CompositeHighlightAction.lookupNodePosition(parentView, node));
        }
    }
}

