/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.filter;

import biouml.model.AbstractFilter;
import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.EquivalentNodeGroup;
import biouml.model.Node;
import biouml.standard.filter.Action;
import biouml.standard.filter.CompositeHighlightAction;
import biouml.standard.filter.HideAction;
import biouml.standard.filter.HighlightAction;
import biouml.standard.filter.ValueActionFilter;
import biouml.standard.filter.ValueActionFilterBeanInfo;
import biouml.standard.type.Base;
import biouml.standard.type.Biopolymer;
import com.developmentontheedge.application.PanelInfo;
import com.developmentontheedge.application.PanelManager;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.swing.PropertyInspector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;

public class BiopolimerDiagramFilter
extends AbstractFilter {
    Diagram diagram;
    private final List<String> species = new ArrayList<String>();
    private final List<String> cellTypes = new ArrayList<String>();
    private final List<String> inducers = new ArrayList<String>();
    PanelManager control;
    SpeciesFilter speciesFilter;
    CellTypeFilter cellTypeFilter;
    InducerFilter inducerFilter;

    public BiopolimerDiagramFilter(Diagram diagram) {
        this.diagram = diagram;
        this.init();
    }

    private void init() {
        long start = System.currentTimeMillis();
        this.collectDiagramInfo(this.diagram);
        if (this.speciesFilter == null || this.cellTypeFilter == null || this.inducerFilter == null) {
            this.speciesFilter = new SpeciesFilter(this, this.getDiagramSpeciesList());
            this.cellTypeFilter = new CellTypeFilter(this, this.getDiagramCellTypesList());
            this.inducerFilter = new InducerFilter(this, this.getDiagramInducersList());
        }
        System.out.println("Load filter data, time=" + (System.currentTimeMillis() - start));
    }

    public BiopolimerDiagramFilter() {
    }

    @Override
    public void setDiagram(Diagram diagram) {
        if (this.diagram != null) {
            return;
        }
        this.diagram = diagram;
        this.init();
    }

    @Override
    public boolean isEnabled() {
        return this.speciesFilter.isEnabled() || this.cellTypeFilter.isEnabled() || this.inducerFilter.isEnabled();
    }

    @Override
    public Component getOptionsControl() {
        if (this.control == null) {
            this.control = new PanelManager();
            this.addFilterControl(this.speciesFilter, "speciesFilter", null);
            this.addFilterControl(this.cellTypeFilter, "cellTypeFilter", "speciesFilter");
            this.addFilterControl(this.inducerFilter, "inducerFilter", "cellTypeFilter");
        }
        return this.control;
    }

    protected void addFilterControl(ValueActionFilter filter, String name, String groupWith) {
        PropertyInspector filterControl = new PropertyInspector();
        filterControl.explore((Object)filter);
        filterControl.setRootVisible(false);
        filterControl.expandAll(true);
        PanelInfo filterInfo = new PanelInfo(name, (JComponent)filterControl, true, null);
        this.control.addPanel(filterInfo, groupWith, 2, 230);
    }

    @Override
    protected void processNode(Node node) {
        if (node instanceof EquivalentNodeGroup) {
            this.processGroup((EquivalentNodeGroup)node);
        } else {
            Action action = this.getNodeAction(node);
            if (action != null) {
                action.apply(node);
            }
        }
    }

    protected Action getNodeAction(Node node) {
        Base kernel = node.getKernel();
        if (!(kernel instanceof Biopolymer)) {
            return null;
        }
        Action action = null;
        if (this.speciesFilter.isEnabled()) {
            action = this.speciesFilter.getAction(node);
        }
        if (action != HideAction.instance && this.cellTypeFilter.isEnabled()) {
            action = this.mergeActions(action, this.cellTypeFilter.getAction(node));
        }
        if (action != HideAction.instance && this.inducerFilter.isEnabled()) {
            action = this.mergeActions(action, this.inducerFilter.getAction(node));
        }
        return action;
    }

    protected void processGroup(EquivalentNodeGroup group) {
        List actions = ((StreamEx)group.stream(Node.class).map(this::getNodeAction).nonNull()).toList();
        if (actions.isEmpty()) {
            return;
        }
        if (actions.size() == group.getSize()) {
            if (actions.stream().allMatch(HideAction.instance::equals)) {
                HideAction.instance.apply(group);
                return;
            }
        }
        CompositeHighlightAction highlight = new CompositeHighlightAction();
        for (Action act : actions) {
            if (act instanceof HighlightAction) {
                highlight.add((HighlightAction)act);
                continue;
            }
            if (!(act instanceof CompositeHighlightAction)) continue;
            highlight.add((CompositeHighlightAction)act);
        }
        highlight.apply(group);
    }

    protected Action mergeActions(Action action1, Action action2) {
        if (action1 == HideAction.instance || action2 == HideAction.instance) {
            return HideAction.instance;
        }
        if (action1 == null) {
            return action2;
        }
        if (action2 == null) {
            return action1;
        }
        return new CompositeHighlightAction(action1, action2);
    }

    @Override
    protected void restoreView(DiagramElement de) {
        CompositeView view = (CompositeView)de.getView();
        de.getView().setVisible(true);
        View highlighter = view.elementAt(0);
        if (highlighter.getModel() instanceof Action) {
            view.remove(highlighter);
        }
    }

    protected void collectDiagramInfo(Compartment comp) {
        for (Node de : comp.stream(Node.class)) {
            String inducerField;
            String cellTypeField;
            if (de instanceof Compartment) {
                this.collectDiagramInfo((Compartment)de);
                continue;
            }
            Base kernel = de.getKernel();
            if (!(kernel instanceof Biopolymer)) continue;
            Biopolymer bp = (Biopolymer)kernel;
            String str = bp.getSpecies();
            if (str != null && !this.species.contains(str = BiopolimerDiagramFilter.normaliseSpecies(str))) {
                this.species.add(str);
            }
            if ((cellTypeField = bp.getSource()) != null) {
                StringTokenizer cellTypeTokenizer = new StringTokenizer(cellTypeField, ";\r\n");
                while (cellTypeTokenizer.hasMoreTokens()) {
                    String cellType = cellTypeTokenizer.nextToken().trim();
                    if (this.cellTypes.contains(cellType)) continue;
                    this.cellTypes.add(cellType);
                }
            }
            if ((inducerField = bp.getRegulation()) == null) continue;
            StringTokenizer inducerTokenizer = new StringTokenizer(inducerField, ";\r\n");
            while (inducerTokenizer.hasMoreTokens()) {
                String inducer = inducerTokenizer.nextToken().trim();
                if (this.inducers.contains(inducer)) continue;
                this.inducers.add(inducer);
            }
        }
        Collections.sort(this.species);
        Collections.sort(this.cellTypes);
        Collections.sort(this.inducers);
    }

    public String[] getDiagramSpeciesList() {
        return this.species.toArray(new String[this.species.size()]);
    }

    public String[] getDiagramCellTypesList() {
        return this.cellTypes.toArray(new String[this.cellTypes.size()]);
    }

    public String[] getDiagramInducersList() {
        return this.inducers.toArray(new String[this.inducers.size()]);
    }

    protected static String normaliseSpecies(String species) {
        int offset = species.indexOf(40);
        if (offset > 0) {
            species = species.substring(0, offset - 1);
        }
        return species;
    }

    public SpeciesFilter getSpeciesFilter() {
        return this.speciesFilter;
    }

    public void setSpeciesFilter(SpeciesFilter filter) {
        SpeciesFilter oldValue = this.speciesFilter;
        this.speciesFilter = filter;
        this.firePropertyChange("speciesFilter", oldValue, this.speciesFilter);
    }

    public CellTypeFilter getCellTypeFilter() {
        return this.cellTypeFilter;
    }

    public void setCellTypeFilter(CellTypeFilter filter) {
        CellTypeFilter oldValue = this.cellTypeFilter;
        this.cellTypeFilter = filter;
        this.firePropertyChange("cellTypeFilter", oldValue, this.cellTypeFilter);
    }

    public InducerFilter getInducerFilter() {
        return this.inducerFilter;
    }

    public void setInducerFilter(InducerFilter filter) {
        InducerFilter oldValue = this.inducerFilter;
        this.inducerFilter = filter;
        this.firePropertyChange("inducerFilter", oldValue, this.inducerFilter);
    }

    public static class InducerFilterBeanInfo
    extends ValueActionFilterBeanInfo {
        public InducerFilterBeanInfo() {
            super(InducerFilter.class);
        }

        protected void initProperties() throws Exception {
            super.initProperties("INDUCER_FILTER");
        }
    }

    public static class InducerFilter
    extends ValueActionFilter {
        public InducerFilter(Option filter, String[] values) {
            super(filter, values, true);
        }

        @Override
        public String getValue(DataElement de) {
            if (de instanceof Biopolymer) {
                return ((Biopolymer)de).getRegulation();
            }
            return null;
        }
    }

    public static class CellTypeFilterBeanInfo
    extends ValueActionFilterBeanInfo {
        public CellTypeFilterBeanInfo() {
            super(CellTypeFilter.class);
        }

        protected void initProperties() throws Exception {
            super.initProperties("CELL_TYPE_FILTER");
        }
    }

    public static class CellTypeFilter
    extends ValueActionFilter {
        public CellTypeFilter(Option filter, String[] values) {
            super(filter, values, true);
        }

        @Override
        public String getValue(DataElement de) {
            if (de instanceof Biopolymer) {
                return ((Biopolymer)de).getSource();
            }
            return null;
        }
    }

    public static class SpeciesFilterBeanInfo
    extends ValueActionFilterBeanInfo {
        public SpeciesFilterBeanInfo() {
            super(SpeciesFilter.class);
        }

        protected void initProperties() throws Exception {
            super.initProperties("SPECIES_FILTER");
        }
    }

    public static class SpeciesFilter
    extends ValueActionFilter {
        public SpeciesFilter(Option filter, String[] values) {
            super(filter, values, false);
        }

        @Override
        public String getValue(DataElement de) {
            String species = null;
            if (de instanceof Biopolymer && (species = ((Biopolymer)de).getSpecies()) != null) {
                species = BiopolimerDiagramFilter.normaliseSpecies(species);
            }
            return species;
        }
    }
}

